/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

class CopyingVisitor
extends ClassVisitor {
    private final boolean renameParent;
    private final String targetClassName;
    private String origClassName;

    public CopyingVisitor(String targetClassName, boolean renameParent, ClassVisitor parent) {
        super(524288, parent);
        this.targetClassName = targetClassName;
        this.renameParent = renameParent;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.renameParent) {
            super.visit(version, access, this.targetClassName, signature, superName, interfaces);
        }
        this.origClassName = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        return new MethodVisitor(589824, super.visitMethod(10, this.getMethodName(name), desc, sig, exceptions)){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
                if (owner.equals(CopyingVisitor.this.origClassName)) {
                    owner = CopyingVisitor.this.targetClassName;
                    name = CopyingVisitor.this.getActionMethodName(name);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itfc);
            }
        };
    }

    protected String getActionMethodName(String name) {
        return name;
    }

    protected String getMethodName(String name) {
        return name;
    }
}

