/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class LineNumberInstrumentor
extends MethodInstrumentor {
    private int lastLine;

    public LineNumberInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.lastLine != 0) {
            this.onAfterLine(line - 1);
        }
        if (!this.isConstructor() || this.isPrologueVisited()) {
            this.onBeforeLine(line);
        }
        this.lastLine = line;
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean iface) {
        boolean beforeConstructor = !this.isPrologueVisited();
        super.visitMethodInsn(opcode, owner, name, desc, iface);
        if (this.lastLine != -1 && beforeConstructor) {
            this.onBeforeLine(this.lastLine);
        }
    }

    protected void onBeforeLine(int line) {
        this.asm.println("before line " + line);
    }

    protected void onAfterLine(int line) {
        this.asm.println("after line " + line);
    }

    public void visitEnd() {
        if (this.lastLine != -1) {
            this.onAfterLine(this.lastLine);
        }
        super.visitEnd();
    }
}

