/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class MethodCallInstrumentor
extends MethodInstrumentor {
    private int callId = 0;

    public MethodCallInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean iface) {
        if (name.startsWith("$btrace")) {
            super.visitMethodInsn(opcode, owner, name, desc, iface);
            return;
        }
        ++this.callId;
        this.onBeforeCallMethod(opcode, owner, name, desc);
        super.visitMethodInsn(opcode, owner, name, desc, iface);
        this.onAfterCallMethod(opcode, owner, name, desc);
    }

    protected void onBeforeCallMethod(int opcode, String owner, String name, String desc) {
        this.asm.println("before call: " + owner + "." + name + desc);
    }

    protected void onAfterCallMethod(int opcode, String owner, String name, String desc) {
        this.asm.println("after call: " + owner + "." + name + desc);
    }

    protected int getCallId() {
        return this.callId;
    }
}

