/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.btrace.core.annotations.Where;
import org.openjdk.btrace.instr.Assembler;
import org.openjdk.btrace.instr.BTraceMethodVisitor;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Level;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.TypeUtils;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.runtime.Interval;

public class MethodInstrumentor
extends BTraceMethodVisitor {
    protected final Assembler asm;
    MethodInstrumentor parent = null;
    private final int access;
    private final String parentClz;
    private final String superClz;
    private final String name;
    private final String desc;
    private final ClassLoader cl;
    private int levelCheckVar = Integer.MIN_VALUE;
    private final Type returnType;
    private final Type[] argumentTypes;
    private final Map<Integer, Type> extraTypes;
    private Label skipLabel;
    private boolean prologueVisited = false;

    public MethodInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, mHelper);
        this.parentClz = parentClz;
        this.superClz = superClz;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.returnType = Type.getReturnType((String)desc);
        this.argumentTypes = Type.getArgumentTypes((String)desc);
        this.extraTypes = new HashMap<Integer, Type>();
        this.asm = new Assembler(this, mHelper);
        this.cl = cl;
    }

    private static boolean isLevelCheck(Level level) {
        return level != null && !level.getValue().equals((Object)Interval.ge((int)0));
    }

    protected void visitMethodPrologue() {
    }

    public final void visitCode() {
        if (!this.isConstructor()) {
            this.prologueVisited = true;
            this.visitMethodPrologue();
        }
        super.visitCode();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean iface) {
        super.visitMethodInsn(opcode, owner, name, desc, iface);
        if (this.isConstructor() && !this.prologueVisited && name.equals("<init>") && (owner.equals(this.getParentClz()) || this.getSuperClz() != null && owner.equals(this.getSuperClz()))) {
            this.prologueVisited = true;
            this.visitMethodPrologue();
        }
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                if (this.prologueVisited) break;
                this.prologueVisited = true;
                this.visitMethodPrologue();
                break;
            }
        }
        super.visitInsn(opcode);
    }

    public int getAccess() {
        return this.access;
    }

    public final String getName() {
        return this.getName(false);
    }

    public final String getName(boolean fqn) {
        StringBuilder sb = new StringBuilder();
        if (fqn) {
            sb.append(Modifier.toString(this.access)).append(' ').append(TypeUtils.descriptorToSimplified(this.desc, this.parentClz, this.name));
        } else {
            sb.append(this.name);
        }
        return sb.toString();
    }

    public final Label getSkipLabel() {
        return this.skipLabel;
    }

    public final void setSkipLabel(Label skipLabel) {
        this.skipLabel = skipLabel;
    }

    public final String getDescriptor() {
        return this.desc;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    protected void addExtraTypeInfo(int index, Type type) {
        if (index != -1) {
            this.extraTypes.put(index, type);
        }
    }

    protected void loadArguments(ArgumentProvider ... argumentProviders) {
        Arrays.sort(argumentProviders, ArgumentProvider.COMPARATOR);
        for (ArgumentProvider provider : argumentProviders) {
            if (provider == null) continue;
            provider.provide();
        }
    }

    protected void loadArguments(ValidationResult vr, Type[] actionArgTypes, boolean isStatic, ArgumentProvider ... argumentProviders) {
        int ptr = isStatic ? 0 : 1;
        ArrayList<ArgumentProvider> argProvidersList = new ArrayList<ArgumentProvider>(argumentProviders.length + vr.getArgCnt());
        argProvidersList.addAll(Arrays.asList(argumentProviders));
        for (int i = 0; i < vr.getArgCnt(); ++i) {
            int index = vr.getArgIdx(i);
            Type t = actionArgTypes[index];
            if (TypeUtils.isAnyTypeArray(t)) {
                argProvidersList.add(this.anytypeArg(index, ptr));
                ++ptr;
                continue;
            }
            argProvidersList.add(this.localVarArg(index, t, ptr));
            ptr += actionArgTypes[index].getSize();
        }
        this.loadArguments(argProvidersList);
    }

    private void loadArguments(List<ArgumentProvider> argumentProviders) {
        argumentProviders.sort(ArgumentProvider.COMPARATOR);
        for (ArgumentProvider ap : argumentProviders) {
            if (ap == null) continue;
            ap.provide();
        }
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' inside static method");
        }
        this.visitVarInsn(25, 0);
    }

    public int[] backupStack(Type[] methodArgTypes, boolean isStatic) {
        int[] backupArgsIndexes = new int[methodArgTypes.length + 1];
        int upper = methodArgTypes.length - 1;
        for (int i = 0; i < methodArgTypes.length; ++i) {
            int index;
            Type t = methodArgTypes[upper - i];
            backupArgsIndexes[upper - i + 1] = index = this.storeAsNew();
        }
        if (!isStatic) {
            int index;
            backupArgsIndexes[0] = index = this.storeAsNew();
        }
        return backupArgsIndexes;
    }

    public void restoreStack(int[] backupArgsIndexes, boolean isStatic) {
        this.restoreStack(backupArgsIndexes, this.argumentTypes, isStatic);
    }

    public void restoreStack(int[] backupArgsIndexes, Type[] methodArgTypes, boolean isStatic) {
        int upper = methodArgTypes.length - 1;
        if (!isStatic) {
            this.asm.loadLocal(Constants.OBJECT_TYPE, backupArgsIndexes[0]);
        }
        for (int i = methodArgTypes.length - 1; i > -1; --i) {
            this.asm.loadLocal(methodArgTypes[upper - i], backupArgsIndexes[upper - i + 1]);
        }
    }

    protected final ArgumentProvider localVarArg(int index, Type type, int ptr) {
        return new LocalVarArgProvider(this.asm, index, type, ptr);
    }

    protected final ArgumentProvider localVarArg(int index, Type type, int ptr, boolean boxValue) {
        return new LocalVarArgProvider(this.asm, index, type, ptr, boxValue);
    }

    protected final ArgumentProvider constArg(int index, Object val) {
        return new ConstantArgProvider(this.asm, index, val);
    }

    protected final ArgumentProvider selfArg(int index, Type type) {
        return this.isStatic() ? this.constArg(index, null) : this.localVarArg(index, type, 0);
    }

    protected final ArgumentProvider anytypeArg(int index, int basePtr) {
        return new AnyTypeArgProvider(this.asm, index, basePtr);
    }

    protected final ArgumentProvider anytypeArg(int index, int basePtr, Type ... argTypes) {
        return new AnyTypeArgProvider(this.asm, index, basePtr, argTypes);
    }

    protected final boolean isStatic() {
        return (this.getAccess() & 8) != 0;
    }

    protected final boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public void returnValue() {
        super.visitInsn(this.returnType.getOpcode(172));
    }

    protected String getParentClz() {
        return this.parentClz;
    }

    protected String getSuperClz() {
        return this.superClz;
    }

    protected ValidationResult validateArguments(OnMethod om, Type[] actionArgTypes, Type[] methodArgTypes) {
        int specialArgsCount = 0;
        if (om.getSelfParameter() != -1) {
            Type selfType = this.extraTypes.get(om.getSelfParameter());
            if (selfType == null) {
                if (!TypeUtils.isObject(actionArgTypes[om.getSelfParameter()])) {
                    this.report("Invalid @Self parameter. @Self parameter is not java.lang.Object. Expected " + Constants.OBJECT_TYPE + ", Received " + actionArgTypes[om.getSelfParameter()]);
                    return ValidationResult.INVALID;
                }
            } else if (!InstrumentUtils.isAssignable(actionArgTypes[om.getSelfParameter()], selfType, this.cl, om.isExactTypeMatch())) {
                this.report("Invalid @Self parameter. @Self parameter is not compatible. Expected " + selfType + ", Received " + actionArgTypes[om.getSelfParameter()]);
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getReturnParameter() != -1) {
            Type type = this.extraTypes.get(om.getReturnParameter());
            if (type == null) {
                type = this.returnType;
            }
            if (type == null) {
                if (!TypeUtils.isObject(actionArgTypes[om.getReturnParameter()])) {
                    this.report("Invalid @Return parameter. @Return parameter is not java.lang.Object. Expected " + Constants.OBJECT_TYPE + ", Received " + actionArgTypes[om.getReturnParameter()]);
                    return ValidationResult.INVALID;
                }
            } else if (!InstrumentUtils.isAssignable(actionArgTypes[om.getReturnParameter()], type, this.cl, om.isExactTypeMatch())) {
                this.report("Invalid @Return parameter. Expected '" + this.returnType + ", received " + actionArgTypes[om.getReturnParameter()]);
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getTargetMethodOrFieldParameter() != -1) {
            if (!InstrumentUtils.isAssignable(actionArgTypes[om.getTargetMethodOrFieldParameter()], Constants.STRING_TYPE, this.cl, om.isExactTypeMatch())) {
                this.report("Invalid @TargetMethodOrField parameter. Expected " + Constants.STRING_TYPE + ", received " + actionArgTypes[om.getTargetMethodOrFieldParameter()]);
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getTargetInstanceParameter() != -1) {
            Type calledType = this.extraTypes.get(om.getTargetInstanceParameter());
            if (calledType == null) {
                if (!TypeUtils.isObject(actionArgTypes[om.getTargetInstanceParameter()])) {
                    this.report("Invalid @TargetInstance parameter. @TargetInstance parameter is not java.lang.Object. Expected " + Constants.OBJECT_TYPE + ", Received " + actionArgTypes[om.getTargetInstanceParameter()]);
                    return ValidationResult.INVALID;
                }
            } else if (!InstrumentUtils.isAssignable(actionArgTypes[om.getTargetInstanceParameter()], calledType, this.cl, om.isExactTypeMatch())) {
                this.report("Invalid @TargetInstance parameter. Expected " + Constants.OBJECT_TYPE + ", received " + actionArgTypes[om.getTargetInstanceParameter()]);
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getDurationParameter() != -1) {
            if (!actionArgTypes[om.getDurationParameter()].equals((Object)Type.LONG_TYPE)) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getClassNameParameter() != -1) {
            if (!InstrumentUtils.isAssignable(actionArgTypes[om.getClassNameParameter()], Constants.STRING_TYPE, this.cl, om.isExactTypeMatch())) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getMethodParameter() != -1) {
            if (!InstrumentUtils.isAssignable(actionArgTypes[om.getMethodParameter()], Constants.STRING_TYPE, this.cl, om.isExactTypeMatch())) {
                return ValidationResult.INVALID;
            }
            ++specialArgsCount;
        }
        Type[] cleansedArgArray = new Type[actionArgTypes.length - specialArgsCount];
        int[] cleansedArgIndex = new int[cleansedArgArray.length];
        int counter = 0;
        for (int argIndex = 0; argIndex < actionArgTypes.length; ++argIndex) {
            if (argIndex == om.getSelfParameter() || argIndex == om.getClassNameParameter() || argIndex == om.getMethodParameter() || argIndex == om.getReturnParameter() || argIndex == om.getTargetInstanceParameter() || argIndex == om.getTargetMethodOrFieldParameter() || argIndex == om.getDurationParameter()) continue;
            cleansedArgArray[counter] = actionArgTypes[argIndex];
            cleansedArgIndex[counter] = argIndex;
            ++counter;
        }
        if (cleansedArgArray.length == 0) {
            return ValidationResult.ANY;
        }
        if (!TypeUtils.isAnyTypeArray(cleansedArgArray[0]) && !InstrumentUtils.isAssignable(cleansedArgArray, methodArgTypes, this.cl, om.isExactTypeMatch())) {
            return ValidationResult.INVALID;
        }
        return new ValidationResult(true, cleansedArgIndex);
    }

    private Label levelCheck(OnMethod om, String className, boolean saveResult) {
        Label l = null;
        Level level = om.getLevel();
        if (MethodInstrumentor.isLevelCheck(level)) {
            l = new Label();
            if (saveResult) {
                this.asm.compareLevel(className, level).dup();
                this.levelCheckVar = this.storeAsNew();
                this.asm.jump(155, l);
            } else {
                this.asm.addLevelCheck(className, level, l);
            }
        }
        return l;
    }

    protected Label levelCheck(OnMethod om, String className) {
        return this.levelCheck(om, className, false);
    }

    protected Label levelCheckBefore(OnMethod om, String className) {
        return this.levelCheck(om, className, om.getLocation().getWhere() == Where.AFTER);
    }

    protected Label levelCheckAfter(OnMethod om, String className) {
        Label l = null;
        if (this.levelCheckVar != Integer.MIN_VALUE) {
            Level level = om.getLevel();
            if (MethodInstrumentor.isLevelCheck(level)) {
                l = new Label();
                this.asm.loadLocal(Type.INT_TYPE, this.levelCheckVar).jump(155, l);
            }
        } else {
            l = this.levelCheck(om, className);
        }
        return l;
    }

    protected final boolean isPrologueVisited() {
        return this.prologueVisited;
    }

    private void report(String msg) {
        String out = "[" + this.getName(true) + "] " + msg;
        System.err.println(out);
    }

    protected class AnyTypeArgProvider
    extends ArgumentProvider {
        private int argPtr;
        private final Type[] myArgTypes;

        public AnyTypeArgProvider(Assembler asm, int index, int basePtr) {
            this(asm, index, basePtr, this$0.argumentTypes);
        }

        public AnyTypeArgProvider(Assembler asm, int index, int basePtr, Type[] argTypes) {
            super(asm, index);
            this.argPtr = basePtr;
            this.myArgTypes = argTypes;
        }

        @Override
        public void doProvide() {
            this.asm.push(this.myArgTypes.length);
            this.asm.newArray(Constants.OBJECT_TYPE);
            for (int j = 0; j < this.myArgTypes.length; ++j) {
                Type argType = this.myArgTypes[j];
                this.asm.dup().push(j).loadLocal(argType, this.argPtr).box(argType).arrayStore(Constants.OBJECT_TYPE);
                this.argPtr += argType.getSize();
            }
        }
    }

    private static class ConstantArgProvider
    extends ArgumentProvider {
        private final Object constant;

        public ConstantArgProvider(Assembler asm, int index, Object constant) {
            super(asm, index);
            this.constant = constant;
        }

        @Override
        public void doProvide() {
            this.asm.ldc(this.constant);
        }

        public String toString() {
            return "Constant " + this.constant + " (@" + this.getIndex() + ")";
        }
    }

    private static class LocalVarArgProvider
    extends ArgumentProvider {
        private final Type type;
        private final int ptr;
        private final boolean boxValue;

        public LocalVarArgProvider(Assembler asm, int index, Type type, int ptr) {
            this(asm, index, type, ptr, false);
        }

        public LocalVarArgProvider(Assembler asm, int index, Type type, int ptr, boolean boxValue) {
            super(asm, index);
            this.type = type;
            this.ptr = ptr;
            this.boxValue = boxValue;
        }

        @Override
        public void doProvide() {
            this.asm.loadLocal(this.type, this.ptr);
            if (this.boxValue) {
                this.asm.box(this.type);
            }
        }

        public String toString() {
            return "LocalVar #" + this.ptr + " of type " + this.type + " (@" + this.getIndex() + ")";
        }
    }

    public static abstract class ArgumentProvider {
        static final Comparator<ArgumentProvider> COMPARATOR = (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null) {
                return 1;
            }
            if (o1.index == o2.index) {
                return 0;
            }
            if (o1.index < o2.index) {
                return -1;
            }
            return 1;
        };
        protected final Assembler asm;
        private final int index;

        public ArgumentProvider(Assembler asm, int index) {
            this.index = index;
            this.asm = asm;
        }

        public int getIndex() {
            return this.index;
        }

        public final void provide() {
            if (this.index > -1) {
                this.doProvide();
            }
        }

        protected abstract void doProvide();
    }

    protected static final class ValidationResult {
        private static final int[] EMPTY_ARRAY = new int[0];
        protected static final ValidationResult INVALID = new ValidationResult(false);
        protected static final ValidationResult ANY = new ValidationResult(true);
        private final boolean isValid;
        private final int[] argsIndex;

        public ValidationResult(boolean valid, int[] argsIndex) {
            if (argsIndex == null) {
                Thread.dumpStack();
            }
            this.isValid = valid;
            this.argsIndex = argsIndex;
        }

        public ValidationResult(boolean valid) {
            this(valid, EMPTY_ARRAY);
        }

        public int getArgIdx(int ptr) {
            return ptr > -1 && ptr < this.argsIndex.length ? this.argsIndex[ptr] : -1;
        }

        public int getArgCnt() {
            return this.argsIndex.length;
        }

        public boolean isAny() {
            return this.isValid && this.argsIndex.length == 0;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidationResult other = (ValidationResult)obj;
            if (this.isValid != other.isValid) {
                return false;
            }
            return Arrays.equals(this.argsIndex, other.argsIndex);
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + (this.isValid ? 1 : 0);
            hash = 59 * hash + Arrays.hashCode(this.argsIndex);
            return hash;
        }
    }
}

