/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.annotations.Sampled;
import org.openjdk.btrace.instr.BTraceMethodNode;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.Level;
import org.openjdk.btrace.instr.Location;
import org.openjdk.btrace.instr.SpecialParameterHolder;

public final class OnMethod
extends SpecialParameterHolder {
    private String clazz;
    private String method = "";
    private boolean exactTypeMatch;
    private String type = "";
    private Location loc = new Location();
    private String targetName;
    private String targetDescriptor;
    private boolean classRegexMatcher = false;
    private boolean methodRegexMatcher = false;
    private boolean classAnnotationMatcher = false;
    private boolean methodAnnotationMatcher = false;
    private boolean subtypeMatcher = false;
    private int samplerMean = 0;
    private Sampled.Sampler samplerKind = Sampled.Sampler.None;
    private Level level = null;
    private boolean isCalled = false;
    private BTraceMethodNode bmn;

    public OnMethod() {
    }

    public OnMethod(BTraceMethodNode bmn) {
        this.bmn = bmn;
    }

    public void copyFrom(OnMethod other) {
        super.copyFrom(other);
        this.setClazz(other.getClazz());
        this.setMethod(other.getMethod());
        this.setExactTypeMatch(other.isExactTypeMatch());
        this.setType(other.getType());
        this.setLocation(other.getLocation());
        this.setLevel(other.getLevel());
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        if (clazz.charAt(0) == '+') {
            this.subtypeMatcher = true;
            clazz = clazz.substring(1);
        } else {
            this.subtypeMatcher = false;
            if (clazz.charAt(0) == '@') {
                this.classAnnotationMatcher = true;
                clazz = clazz.substring(1);
            } else {
                this.classAnnotationMatcher = false;
            }
            if (clazz.charAt(0) == '/' && Constants.REGEX_SPECIFIER.matcher(clazz).matches()) {
                this.classRegexMatcher = true;
                clazz = clazz.substring(1, clazz.length() - 1);
            } else {
                this.classRegexMatcher = false;
            }
        }
        this.clazz = clazz;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        char firstChar;
        char c = firstChar = method.isEmpty() ? (char)'\u0000' : method.charAt(0);
        if (firstChar == '@') {
            this.methodAnnotationMatcher = true;
            method = method.substring(1);
        } else {
            this.methodAnnotationMatcher = false;
        }
        char c2 = firstChar = method.isEmpty() ? (char)'\u0000' : method.charAt(0);
        if (firstChar == '/' && Constants.REGEX_SPECIFIER.matcher(method).matches()) {
            this.methodRegexMatcher = true;
            method = method.substring(1, method.length() - 1);
        } else {
            this.methodRegexMatcher = false;
        }
        this.method = method;
    }

    public boolean isExactTypeMatch() {
        return this.exactTypeMatch;
    }

    public void setExactTypeMatch(boolean exactTypeMatch) {
        this.exactTypeMatch = exactTypeMatch;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Location getLocation() {
        return this.loc;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String name) {
        this.targetName = name;
    }

    public String getTargetDescriptor() {
        return this.targetDescriptor;
    }

    public void setTargetDescriptor(String desc) {
        this.targetDescriptor = desc;
    }

    public Sampled.Sampler getSamplerKind() {
        return this.samplerKind;
    }

    public void setSamplerKind(Sampled.Sampler kind) {
        this.samplerKind = kind;
    }

    public int getSamplerMean() {
        return this.samplerMean;
    }

    public void setSamplerMean(int mean) {
        this.samplerMean = mean;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public BTraceMethodNode getMethodNode() {
        return this.bmn;
    }

    public boolean isClassRegexMatcher() {
        return this.classRegexMatcher;
    }

    public boolean isMethodRegexMatcher() {
        return this.methodRegexMatcher;
    }

    public boolean isClassAnnotationMatcher() {
        return this.classAnnotationMatcher;
    }

    public boolean isMethodAnnotationMatcher() {
        return this.methodAnnotationMatcher;
    }

    public boolean isSubtypeMatcher() {
        return this.subtypeMatcher;
    }

    public boolean isCalled() {
        return this.isCalled;
    }

    public void setCalled() {
        this.isCalled = true;
    }

    public String toString() {
        return "OnMethod{clazz=" + this.clazz + ", method=" + this.method + ", type=" + this.type + ", loc=" + this.loc + ", targetName=" + this.targetName + ", targetDescriptor=" + this.targetDescriptor + ", classRegexMatcher=" + this.classRegexMatcher + ", methodRegexMatcher=" + this.methodRegexMatcher + ", classAnnotationMatcher=" + this.classAnnotationMatcher + ", methodAnnotationMatcher=" + this.methodAnnotationMatcher + ", subtypeMatcher=" + this.subtypeMatcher + ", samplerMean=" + this.samplerMean + ", samplerKind=" + this.samplerKind + ", level=" + this.level + ", bmn=" + (Object)((Object)this.bmn) + '}';
    }

    void applyArgs(ArgsMap argsMap) {
        String templated;
        Location loc;
        String templated2;
        String value = this.getClazz();
        if (!value.isEmpty() && !(templated2 = argsMap.template(value)).equals(value)) {
            this.setClazz(templated2);
        }
        if (!(value = this.getMethod()).isEmpty() && !(templated2 = argsMap.template(value)).equals(value)) {
            this.setMethod(templated2);
        }
        if (!(value = this.getType()).isEmpty() && !(templated2 = argsMap.template(value)).equals(value)) {
            this.setType(templated2);
        }
        if (!(value = (loc = this.getLocation()).getClazz()).isEmpty() && !(templated = argsMap.template(value)).equals(value)) {
            loc.setClazz(templated);
        }
        if (!(value = loc.getMethod()).isEmpty() && !(templated = argsMap.template(value)).equals(value)) {
            loc.setMethod(templated);
        }
        if (!(value = loc.getField()).isEmpty() && !(templated = argsMap.template(value)).equals(value)) {
            loc.setField(templated);
        }
        if (!(value = loc.getType()).isEmpty() && !(templated = argsMap.template(value)).equals(value)) {
            loc.setType(templated);
        }
    }
}

