/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.core.Messages;
import org.openjdk.btrace.core.VerifierException;
import org.openjdk.btrace.instr.BTraceProbeNode;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.FieldVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class Verifier
extends ClassVisitor {
    private final boolean trustedAllowed;
    private final BTraceProbeNode cn;
    private boolean seenBTrace;

    public Verifier(BTraceProbeNode cv, boolean trusted) {
        super(589824, (ClassVisitor)cv);
        this.trustedAllowed = trusted;
        this.cn = cv;
    }

    public static void reportError(String err) {
        Verifier.reportError(err, null);
    }

    public static void reportError(String err, String msg) {
        String str = Messages.get(err);
        if (msg != null) {
            str = str + ": " + msg;
        }
        throw new VerifierException(str);
    }

    public String getClassName() {
        return this.cn.name;
    }

    public void visitEnd() {
        if (!this.trustedAllowed && !this.cn.isTrusted() && this.cn.getGraph().hasCycle()) {
            this.reportSafetyError("execution.loop.danger");
        }
        super.visitEnd();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!this.trustedAllowed && !this.cn.isTrusted()) {
            if ((access & 0x200) != 0 || (access & 0x4000) != 0) {
                this.reportSafetyError("btrace.program.should.be.class");
            }
            if ((access & 1) == 0) {
                this.reportSafetyError("class.should.be.public", name);
            }
            if (!superName.equals("java/lang/Object")) {
                this.reportSafetyError("object.superclass.required", superName);
            }
            if (interfaces != null && interfaces.length > 0) {
                this.reportSafetyError("no.interface.implementation");
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String type, boolean visible) {
        AnnotationVisitor delegate = super.visitAnnotation(type, visible);
        if (type.equals(Constants.BTRACE_DESC)) {
            this.seenBTrace = true;
            return new AnnotationVisitor(589824, delegate){

                public void visit(String name, Object value) {
                    if (("unsafe".equals(name) || "trusted".equals(name)) && Boolean.TRUE.equals(value)) {
                        if (!Verifier.this.trustedAllowed) {
                            Verifier.this.reportSafetyError("agent.unsafe.not.allowed");
                        }
                        Verifier.this.cn.setTrusted();
                    }
                    super.visit(name, value);
                }
            };
        }
        return delegate;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.seenBTrace) {
            this.reportSafetyError("not.a.btrace.program");
        }
        if (!this.trustedAllowed && !this.cn.isTrusted() && (access & 8) == 0) {
            this.reportSafetyError("agent.no.instance.variables", name);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (!this.trustedAllowed && !this.cn.isTrusted() && this.cn.name.equals(outerName)) {
            this.reportSafetyError("no.nested.class");
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        if (!this.seenBTrace) {
            this.reportSafetyError("not.a.btrace.program");
        }
        if (!this.trustedAllowed && !this.cn.isTrusted()) {
            if ((access & 0x20) != 0) {
                this.reportSafetyError("no.synchronized.methods", methodName + methodDesc);
            }
            if (!methodName.equals("<init>") && (access & 8) == 0) {
                this.reportSafetyError("no.instance.method", methodName + methodDesc);
            }
        }
        return super.visitMethod(access, methodName, methodDesc, signature, exceptions);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (!this.trustedAllowed && !this.cn.isTrusted()) {
            this.reportSafetyError("no.outer.class");
        }
    }

    void reportSafetyError(String err) {
        this.reportSafetyError(err, null);
    }

    void reportSafetyError(String err, String msg) {
        Verifier.reportError(err, msg);
    }
}

