/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.client;

import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

final class JpsUtils {
    private static final Logger log = LoggerFactory.getLogger(JpsUtils.class);

    JpsUtils() {
    }

    static Integer findVmByName(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException ignored) {
            Integer pid = null;
            try {
                MonitoredHost vmHost = MonitoredHost.getMonitoredHost((String)null);
                for (Integer vmPid : MonitoredHost.getMonitoredHost("localhost").activeVms()) {
                    VmIdentifier id = new VmIdentifier(vmPid.toString());
                    MonitoredVm vm = vmHost.getMonitoredVm(id);
                    String mainClass = MonitoredVmUtil.mainClass(vm, false);
                    if (!name.equalsIgnoreCase(mainClass)) continue;
                    pid = vmPid;
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Unexpected exception", e);
            }
            return pid;
        }
    }

    static Collection<String> listVms() {
        ArrayList<String> vms = new ArrayList<String>();
        try {
            MonitoredHost vmHost = MonitoredHost.getMonitoredHost((String)null);
            for (Integer vmPid : MonitoredHost.getMonitoredHost("localhost").activeVms()) {
                VmIdentifier id = new VmIdentifier(vmPid.toString());
                MonitoredVm mvm = vmHost.getMonitoredVm(id);
                if (!MonitoredVmUtil.isAttachable(mvm)) continue;
                String mainClass = MonitoredVmUtil.mainClass(mvm, false);
                vms.add("(" + (JpsUtils.hasBTraceServer(vmPid) ? "+" : "-") + ") " + vmPid + " " + mainClass + " [" + MonitoredVmUtil.commandLine(mvm) + "]");
            }
        }
        catch (Exception e) {
            log.warn("Unexpected exception", e);
        }
        return vms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasBTraceServer(int pid) {
        boolean result = false;
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(String.valueOf(pid));
            result = vm.getSystemProperties().containsKey("btrace.port");
        }
        catch (Throwable throwable) {
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

