/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.compiler;

import com.sun.source.util.JavacTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.openjdk.btrace.compiler.Compiler;
import org.openjdk.btrace.compiler.CompilerClassWriter;
import org.openjdk.btrace.compiler.MemoryJavaFileManager;
import org.openjdk.btrace.compiler.PackGenerator;
import org.openjdk.btrace.compiler.Postprocessor;
import org.openjdk.btrace.compiler.Verifier;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;

class CompilerHelper {
    private final boolean generatePack;
    private final JavaCompiler compiler;

    CompilerHelper(JavaCompiler compiler, boolean generatePack) {
        this.compiler = compiler;
        this.generatePack = generatePack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, byte[]> compile(MemoryJavaFileManager manager, Iterable<? extends JavaFileObject> compUnits, Writer err, String sourcePath, String classPath) {
        PrintWriter perr;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:all");
        options.add("-g:lines");
        options.add("-deprecation");
        options.add("-source");
        options.add("1.7");
        options.add("-target");
        options.add("1.7");
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(sourcePath);
        }
        if (classPath != null) {
            options.add("-classpath");
            options.add(classPath);
        }
        JavacTask task = (JavacTask)this.compiler.getTask(err, manager, diagnostics, options, null, compUnits);
        Verifier btraceVerifier = new Verifier();
        task.setTaskListener(btraceVerifier);
        ArrayList<Verifier> processors = new ArrayList<Verifier>(1);
        processors.add(btraceVerifier);
        task.setProcessors(processors);
        PrintWriter printWriter = perr = err instanceof PrintWriter ? (PrintWriter)err : new PrintWriter(err);
        if (!task.call().booleanValue() || this.containsErrors(diagnostics)) {
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                this.printDiagnostic(diagnostic, perr);
            }
            perr.flush();
            return null;
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try {
            Map<String, byte[]> classBytes = manager.getClassBytes();
            List<String> classNames = btraceVerifier.getClassNames();
            for (String name : classNames) {
                if (!classBytes.containsKey(name)) continue;
                this.dump(name + "_before", classBytes.get(name));
                ClassReader cr = new ClassReader(classBytes.get(name));
                CompilerClassWriter cw = new CompilerClassWriter(classPath, perr);
                cr.accept(new Postprocessor(cw), 10);
                byte[] classData = cw.toByteArray();
                this.dump(name + "_after", classData);
                if (this.generatePack) {
                    SharedSettings.GLOBAL.setTrusted(true);
                    String[] pathElements = classPath.split(File.pathSeparator);
                    ArrayList<URL> urlElements = new ArrayList<URL>(pathElements.length);
                    for (String pathElement : pathElements) {
                        File f = new File(pathElement);
                        urlElements.add(f.toURI().toURL());
                    }
                    URLClassLoader generatorCL = new URLClassLoader(urlElements.toArray(new URL[0]), Compiler.class.getClassLoader());
                    ServiceLoader<PackGenerator> generators = ServiceLoader.load(PackGenerator.class, generatorCL);
                    Iterator<PackGenerator> iter = generators.iterator();
                    if (iter.hasNext()) {
                        PackGenerator generator = iter.next();
                        SharedSettings.GLOBAL.setBootClassPath(classPath);
                        classData = generator.generateProbePack(classData);
                    }
                }
                result.put(name, classData);
            }
        }
        catch (IOException e) {
            e.printStackTrace(perr);
        }
        finally {
            try {
                manager.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String name, byte[] code) {
        OutputStream os = null;
        try {
            name = name.replace(".", "_") + ".class";
            File f = new File("/tmp/" + name);
            if (!f.exists()) {
                f.getParentFile().createNewFile();
            }
            os = new FileOutputStream(f);
            os.write(code);
        }
        catch (IOException iOException) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void printDiagnostic(Diagnostic diagnostic, PrintWriter perr) {
        perr.println(diagnostic);
    }

    private boolean containsErrors(DiagnosticCollector<?> diagnostics) {
        for (Diagnostic<?> diagnostic : diagnostics.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            return true;
        }
        return false;
    }
}

