/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.compiler;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

class Printer {
    static int debugPrintIndentLevel = 0;
    private final PrintWriter writer;
    private final ArrayList<Boolean> enabledBits = new ArrayList();

    Printer() {
        this.writer = new PrintWriter(System.err);
    }

    Printer(Writer out) {
        this.writer = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    public static int getDebugPrintIndentLevel() {
        return debugPrintIndentLevel;
    }

    void println() {
        if (this.enabled()) {
            this.writer.println();
        }
    }

    boolean enabled() {
        return this.enabledBits.isEmpty() || this.enabledBits.get(this.enabledBits.size() - 1) != false;
    }

    void pushEnableBit(boolean enabled) {
        this.enabledBits.add(enabled);
        ++debugPrintIndentLevel;
    }

    void print(String s) {
        if (this.enabled()) {
            this.writer.print(s);
        }
    }

    void flush() {
        if (this.enabled()) {
            this.writer.flush();
        }
    }

    void popEnableBit() {
        if (this.enabledBits.isEmpty()) {
            System.err.println("WARNING: mismatched #ifdef/endif pairs");
            return;
        }
        this.enabledBits.remove(this.enabledBits.size() - 1);
        --debugPrintIndentLevel;
    }
}

