/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import org.openjdk.btrace.core.Function;

public final class CircularBuffer<T> {
    private final T[] elements;
    private final int size;
    private long readIndex = 0L;
    private long writeIndex = -1L;
    private int length = 0;

    public CircularBuffer(int size) {
        this.size = size;
        this.elements = new Object[size];
    }

    public void add(T element) {
        int newIndex = (int)(++this.writeIndex) % this.size;
        this.elements[newIndex] = element;
        int nextIndex = (newIndex + 1) % this.size;
        if (this.elements[nextIndex] != null) {
            this.readIndex = nextIndex;
        }
        if (++this.length > this.size) {
            this.length = this.size;
        }
    }

    public boolean forEach(Function<T, Boolean> functor) {
        for (int cntr = 0; cntr < this.size && this.writeIndex >= this.readIndex; ++cntr) {
            if (functor.apply(this.elements[(int)this.readIndex % this.size]).booleanValue()) {
                ++this.readIndex;
                if (--this.length >= 0) continue;
                this.length = 0;
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean doNext(Function<T, Boolean> nextWork) {
        if (this.writeIndex >= this.readIndex && nextWork.apply(this.elements[(int)this.readIndex % this.size]).booleanValue()) {
            ++this.readIndex;
            return true;
        }
        return false;
    }

    public int getLength() {
        return this.length;
    }
}

