/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.impl.SimpleLogger;

public final class DebugSupport {
    private final SharedSettings settings;

    public static void initLoggers(boolean debug, Logger logger) {
        String logFile = System.getProperty("org.openjdk.btrace.libs.org.slf4j.simpleLogger.logFile");
        System.setProperty("org.openjdk.btrace.libs.org.slf4j.simpleLogger.logFile", logFile != null ? logFile : "System.out");
        String defaultLevel = System.getProperty("org.openjdk.btrace.libs.org.slf4j.simpleLogger.log.org.openjdk.btrace", "info");
        System.setProperty("org.openjdk.btrace.libs.org.slf4j.simpleLogger.defaultLogLevel", debug ? "debug" : defaultLevel);
        try {
            Method mthd = SimpleLogger.class.getDeclaredMethod("init", new Class[0]);
            mthd.setAccessible(true);
            mthd.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("[btrace] Unable to reload logger config");
        }
        if (logger != null) {
            try {
                Field fld = logger.getClass().getDeclaredField("currentLogLevel");
                fld.setAccessible(true);
                fld.set(logger, debug ? 10 : 20);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                System.err.println("[btrace] Unable to set debug log level");
            }
        }
    }

    public DebugSupport(SharedSettings s) {
        this.settings = s != null ? s : SharedSettings.GLOBAL;
    }

    public boolean isDebug() {
        return this.settings.isDebug();
    }

    public boolean isDumpClasses() {
        return this.settings.isDumpClasses();
    }

    public String getDumpClassDir() {
        return this.settings.getDumpDir();
    }

    public void dumpClass(String className, byte[] code) {
        if (this.settings.isDumpClasses()) {
            try {
                className = className.replace(".", File.separator).replace("/", File.separator);
                int index = className.lastIndexOf(File.separatorChar);
                StringBuilder buf = new StringBuilder();
                if (!this.settings.getDumpDir().equals(".")) {
                    buf.append(this.settings.getDumpDir());
                    buf.append(File.separatorChar);
                }
                String dir = buf.toString();
                if (index != -1) {
                    dir = dir + className.substring(0, index);
                }
                new File(dir).mkdirs();
                String file = index != -1 ? className.substring(index + 1) : className;
                file = file + ".class";
                new File(dir).mkdirs();
                File out = new File(dir, file);
                try (FileOutputStream fos = new FileOutputStream(out);){
                    fos.write(code);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }
}

