/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import java.util.Map;

public final class SharedSettings {
    public static final String DEBUG_KEY = "debug";
    public static final String DUMP_DIR_KEY = "dumpDir";
    @Deprecated
    public static final String UNSAFE_KEY = "unsafe";
    public static final String TRUSTED_KEY = "trusted";
    public static final String TRACK_RETRANSFORMS_KEY = "trackRetransforms";
    public static final String PROBE_DESC_PATH_KEY = "probeDescPath";
    public static final String STATSD_HOST_KEY = "statsdHost";
    public static final String STATSD_PORT_KEY = "statsdPort";
    public static final String FILEROLL_INTERVAL_KEY = "fileRollMilliseconds";
    public static final String FILEROLL_MAXROLLS_KEY = "fileRollMaxRolls";
    public static final String OUTPUT_FILE_KEY = "scriptOutputFile";
    public static final String OUTPUT_DIR_KEY = "scriptOutputDir";
    public static final SharedSettings GLOBAL = new SharedSettings();
    private boolean debug = false;
    private boolean trusted = false;
    private boolean trackRetransforms = false;
    private boolean retransformStartup = true;
    private String dumpDir = null;
    private String probeDescPath = ".";
    private String bootClassPath = "";
    private final String systemClassPath = "";
    private String statsdHost = null;
    private int statsdPort = 8125;
    private int fileRollMilliseconds = Integer.MIN_VALUE;
    private int fileRollMaxRolls = 5;
    private String outputFile;
    private String scriptDir;
    private String scriptOutputDir;
    private String clientName;

    public void from(Map<String, Object> params) {
        Integer i;
        String s;
        Boolean b = (Boolean)params.get(DEBUG_KEY);
        if (b != null) {
            this.debug = b;
        }
        if ((b = (Boolean)params.get(TRACK_RETRANSFORMS_KEY)) != null) {
            this.trackRetransforms = b;
        }
        if ((b = (Boolean)params.get(UNSAFE_KEY)) != null) {
            this.trusted = b;
        }
        if ((b = (Boolean)params.get(TRUSTED_KEY)) != null) {
            this.trusted |= b.booleanValue();
        }
        if ((s = (String)params.get(DUMP_DIR_KEY)) != null && !s.isEmpty()) {
            this.dumpDir = s;
        }
        if ((s = (String)params.get(PROBE_DESC_PATH_KEY)) != null && !s.isEmpty()) {
            this.probeDescPath = s;
        }
        if ((s = (String)params.get("bootClassPath")) != null && !s.isEmpty()) {
            this.bootClassPath = s;
        }
        if ((s = (String)params.get(STATSD_HOST_KEY)) != null && !s.isEmpty()) {
            this.statsdHost = s;
        }
        if ((i = (Integer)params.get(STATSD_PORT_KEY)) != null) {
            this.statsdPort = i;
        }
        if ((i = (Integer)params.get(FILEROLL_INTERVAL_KEY)) != null) {
            this.fileRollMilliseconds = i;
        }
        if ((i = (Integer)params.get(FILEROLL_MAXROLLS_KEY)) != null) {
            this.fileRollMaxRolls = i;
        }
        if ((s = (String)params.get(OUTPUT_FILE_KEY)) != null && !s.isEmpty()) {
            this.outputFile = s;
        }
        if ((s = (String)params.get(OUTPUT_DIR_KEY)) != null && !s.isEmpty()) {
            this.scriptOutputDir = s;
        }
    }

    public void from(SharedSettings other) {
        this.clientName = other.clientName;
        this.debug = other.debug;
        this.dumpDir = other.dumpDir;
        this.fileRollMilliseconds = other.fileRollMilliseconds;
        this.fileRollMaxRolls = other.fileRollMaxRolls;
        this.outputFile = other.outputFile;
        this.scriptDir = other.scriptDir;
        this.scriptOutputDir = other.scriptOutputDir;
        this.probeDescPath = other.probeDescPath;
        this.bootClassPath = other.bootClassPath;
        this.retransformStartup = other.retransformStartup;
        this.statsdHost = other.statsdHost;
        this.statsdPort = other.statsdPort;
        this.trackRetransforms = other.trackRetransforms;
        this.trusted = other.trusted;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public boolean isDumpClasses() {
        return this.dumpDir != null;
    }

    @Deprecated
    public boolean isUnsafe() {
        return this.trusted;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean value) {
        this.trusted = value;
    }

    public String getDumpDir() {
        return this.dumpDir;
    }

    public void setDumpDir(String value) {
        this.dumpDir = value;
    }

    public boolean isTrackRetransforms() {
        return this.trackRetransforms;
    }

    public void setTrackRetransforms(boolean value) {
        this.trackRetransforms = value;
    }

    public String getProbeDescPath() {
        return this.probeDescPath;
    }

    public void setProbeDescPath(String probeDescPath) {
        this.probeDescPath = probeDescPath;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public void setBootClassPath(String bootClassPath) {
        this.bootClassPath = bootClassPath;
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public void setStatsdHost(String statsdHost) {
        this.statsdHost = statsdHost;
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }

    public void setStatsdPort(int statsdPort) {
        this.statsdPort = statsdPort;
    }

    public int getFileRollMilliseconds() {
        return this.fileRollMilliseconds;
    }

    public void setFileRollMilliseconds(int fileRollMilliseconds) {
        this.fileRollMilliseconds = fileRollMilliseconds;
    }

    public int getFileRollMaxRolls() {
        return this.fileRollMaxRolls;
    }

    public void setFileRollMaxRolls(int fileRollMaxRolls) {
        this.fileRollMaxRolls = fileRollMaxRolls;
    }

    public boolean isRetransformStartup() {
        return this.retransformStartup;
    }

    public void setRetransformStartup(boolean val) {
        this.retransformStartup = val;
    }

    public String getScriptDir() {
        return this.scriptDir;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getScriptOutputDir() {
        return this.scriptOutputDir;
    }

    public void setScriptOutputDir(String scriptOutputDir) {
        this.scriptOutputDir = scriptOutputDir;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }
}

