/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.comm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public abstract class Command
implements Serializable {
    public static final byte ERROR = 0;
    public static final byte EVENT = 1;
    public static final byte EXIT = 2;
    public static final byte INSTRUMENT = 3;
    public static final byte MESSAGE = 4;
    public static final byte RENAME = 5;
    public static final byte STATUS = 6;
    public static final byte NUMBER_MAP = 7;
    public static final byte STRING_MAP = 8;
    public static final byte NUMBER = 9;
    public static final byte GRID_DATA = 10;
    public static final byte RETRANSFORMATION_START = 11;
    public static final byte RETRANSFORM_CLASS = 12;
    public static final byte SET_PARAMS = 13;
    public static final byte LIST_PROBES = 14;
    public static final byte DISCONNECT = 15;
    public static final byte RECONNECT = 16;
    public static final byte FIRST_COMMAND = 0;
    public static final byte LAST_COMMAND = 16;
    public static final Command NULL = new Command(){

        @Override
        protected void write(ObjectOutput out) throws IOException {
        }

        @Override
        protected void read(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    };
    protected byte type;
    private boolean urgent;

    protected Command(byte type) {
        this(type, true);
    }

    protected Command(byte type, boolean urgent) {
        if (type < 0 || type > 16) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.urgent = urgent;
    }

    private Command() {
        this.type = (byte)-1;
        this.urgent = true;
    }

    protected abstract void write(ObjectOutput var1) throws IOException;

    protected abstract void read(ObjectInput var1) throws IOException, ClassNotFoundException;

    public final byte getType() {
        return this.type;
    }

    public final boolean isUrgent() {
        return this.urgent;
    }

    final void setUrgent() {
        this.urgent = true;
    }
}

