/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.comm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.PrintableCommand;

public class ListProbesCommand
extends Command
implements PrintableCommand {
    private final List<String> probes = new ArrayList<String>();

    public ListProbesCommand() {
        super((byte)14, true);
    }

    public void setProbes(Collection<String> probes) {
        this.probes.clear();
        this.probes.addAll(probes);
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeInt(this.probes.size());
        for (String probe : this.probes) {
            out.writeUTF(probe);
        }
    }

    @Override
    protected void read(ObjectInput in) throws IOException, ClassNotFoundException {
        int numProbes = in.readInt();
        for (int i = 0; i < numProbes; ++i) {
            this.probes.add(in.readUTF());
        }
    }

    @Override
    public void print(PrintWriter out) {
        int cntr = 1;
        for (String probe : this.probes) {
            out.println(cntr++ + ": " + probe);
        }
    }
}

