/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.Location;
import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

public class ArrayAccessInstrumentor
extends MethodInstrumentor {
    public ArrayAccessInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitInsn(int opcode) {
        boolean arrayload = false;
        boolean arraystore = false;
        switch (opcode) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                arrayload = true;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                arraystore = true;
            }
        }
        if (arrayload) {
            this.onBeforeArrayLoad(opcode);
        } else if (arraystore) {
            this.onBeforeArrayStore(opcode);
        }
        super.visitInsn(opcode);
        if (arrayload) {
            this.onAfterArrayLoad(opcode);
        } else if (arraystore) {
            this.onAfterArrayStore(opcode);
        }
    }

    protected final boolean locationTypeMismatch(Location loc, Type arrtype, Type itemType) {
        return !loc.getType().isEmpty() && !loc.getType().equals(arrtype.getClassName()) && !loc.getType().equals(itemType.getClassName());
    }

    protected void onBeforeArrayLoad(int opcode) {
    }

    protected void onAfterArrayLoad(int opcode) {
    }

    protected void onBeforeArrayStore(int opcode) {
    }

    protected void onAfterArrayStore(int opcode) {
    }
}

