/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.openjdk.btrace.instr.BailoutException;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Attribute;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

final class BTraceClassReader
extends ClassReader {
    private static final Method getAttributesMthd;
    private static final Method readAnnotationValuesMthd;
    private static final Field itemsFld;
    private static final Field mslFld;
    private final ClassLoader cl;

    BTraceClassReader(ClassLoader cl, byte[] bytes) {
        super(bytes);
        this.cl = cl;
    }

    BTraceClassReader(ClassLoader cl, InputStream in) throws IOException {
        super(in);
        this.cl = cl;
    }

    public static void bailout() {
        throw BailoutException.INSTANCE;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public String getJavaClassName() {
        return this.getClassName().replace('/', '.');
    }

    public String[] readClassSupers() {
        String[] ifaces = this.getInterfaces();
        String[] supers = Arrays.copyOf(ifaces, ifaces.length + 1);
        supers[supers.length - 1] = this.getSuperName();
        return supers;
    }

    public boolean isInterface() {
        return (this.getAccess() & 0x200) != 0;
    }

    public boolean isBTrace() {
        return this.getAnnotationTypes().contains(Constants.BTRACE_DESC);
    }

    public Collection<String> getAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        char[] c = new char[this.getMaxStringLength()];
        int anns = this.getAnnotationsOffset(c);
        if (anns != -1) {
            int v = anns + 2;
            for (int i = this.readUnsignedShort(anns); i > 0; --i) {
                types.add(Type.getType(this.readUTF8(v, c)).getClassName());
                v = this.skipAnnotationValues(v + 2, c);
                if (v == -1) break;
            }
        }
        return types;
    }

    public int getClassVersion() {
        try {
            if (itemsFld != null) {
                int[] items = (int[])itemsFld.get(this);
                return this.readInt(items[1] - 7);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 51;
    }

    @Override
    public void accept(ClassVisitor cv, Attribute[] atrbts, int i) {
        try {
            super.accept(cv, atrbts, i);
        }
        catch (BailoutException bailoutException) {
            // empty catch block
        }
    }

    @Override
    public void accept(ClassVisitor cv, int i) {
        try {
            super.accept(cv, i);
        }
        catch (BailoutException bailoutException) {
            // empty catch block
        }
    }

    private int getAttributes() {
        try {
            if (getAttributesMthd != null) {
                return (Integer)getAttributesMthd.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    private int getAnnotationsOffset(char[] buf) {
        int u = this.getAttributes();
        if (u == -1) {
            return -1;
        }
        for (int i = this.readUnsignedShort(u - 2); i > 0; --i) {
            String attrName = this.readUTF8(u, buf);
            int attributeLength = this.readInt(u + 2);
            u += 6;
            if ("RuntimeVisibleAnnotations".equals(attrName)) {
                return u;
            }
            u += attributeLength;
        }
        return -1;
    }

    private int skipAnnotationValues(int off, char[] buf) {
        try {
            if (readAnnotationValuesMthd != null) {
                return (Integer)readAnnotationValuesMthd.invoke((Object)this, null, off, null, buf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    static {
        Method m1 = null;
        Method m2 = null;
        Field f1 = null;
        Field f2 = null;
        try {
            m1 = ClassReader.class.getDeclaredMethod("getFirstAttributeOffset", new Class[0]);
            m1.setAccessible(true);
            m2 = ClassReader.class.getDeclaredMethod("readElementValue", AnnotationVisitor.class, Integer.TYPE, String.class, char[].class);
            m2.setAccessible(true);
            f1 = ClassReader.class.getDeclaredField("cpInfoOffsets");
            f1.setAccessible(true);
            f2 = ClassReader.class.getDeclaredField("maxStringLength");
            f2.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        getAttributesMthd = m1;
        readAnnotationValuesMthd = m2;
        itemsFld = f1;
        mslFld = f2;
    }
}

