/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Instrumentor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodNode;

final class BTraceClassWriter
extends ClassWriter {
    private final Deque<Instrumentor> instrumentors = new ArrayDeque<Instrumentor>();
    private final ClassLoader targetCL;
    private final BTraceClassReader cr;
    private final Collection<MethodNode> cushionMethods = new HashSet<MethodNode>();

    BTraceClassWriter(ClassLoader cl, int flags) {
        super(flags);
        this.targetCL = cl != null ? cl : ClassLoader.getSystemClassLoader();
        this.cr = null;
    }

    BTraceClassWriter(ClassLoader cl, BTraceClassReader reader, int flags) {
        super(reader, flags);
        this.targetCL = cl != null ? cl : ClassLoader.getSystemClassLoader();
        this.cr = reader;
    }

    public void addInstrumentor(BTraceProbe bp) {
        this.addInstrumentor(bp, null);
    }

    public void addInstrumentor(BTraceProbe bp, ClassLoader cl) {
        Instrumentor top;
        ClassVisitor parent;
        Instrumentor i;
        if (this.cr != null && bp != null && (i = Instrumentor.create(this.cr, bp, parent = (top = this.instrumentors.peekLast()) != null ? top : this, cl)) != null) {
            this.instrumentors.add(i);
        }
    }

    public byte[] instrument() {
        boolean hit = false;
        if (this.instrumentors.isEmpty()) {
            return null;
        }
        final Instrumentor top = this.instrumentors.peekLast();
        ClassVisitor cv = new ClassVisitor(589824, top != null ? top : this){

            @Override
            public void visitEnd() {
                if (top != null && top.hasCushionMethods()) {
                    for (MethodNode m : BTraceClassWriter.this.cushionMethods) {
                        m.accept(this);
                    }
                }
                super.visitEnd();
            }
        };
        InstrumentUtils.accept(this.cr, cv);
        for (Instrumentor i : this.instrumentors) {
            hit |= i.hasMatch();
        }
        return hit ? this.toByteArray() : null;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        LinkedHashSet<String> type1Closure = new LinkedHashSet<String>();
        LinkedHashSet<String> type2Closure = new LinkedHashSet<String>();
        InstrumentUtils.collectHierarchyClosure(this.targetCL, type1, type1Closure, true);
        InstrumentUtils.collectHierarchyClosure(this.targetCL, type2, type2Closure, true);
        type1Closure.retainAll(type2Closure);
        Iterator iter = type1Closure.iterator();
        if (iter.hasNext()) {
            return (String)iter.next();
        }
        return "java/lang/Object";
    }

    public void addCushionMethods(Collection<MethodNode> pillowMethods) {
        this.cushionMethods.addAll(pillowMethods);
    }
}

