/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.VerifierException;
import org.openjdk.btrace.core.annotations.Kind;
import org.openjdk.btrace.core.annotations.Sampled;
import org.openjdk.btrace.core.annotations.Where;
import org.openjdk.btrace.core.comm.RetransformClassNotification;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceMethodNode;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.BTraceProbeFactory;
import org.openjdk.btrace.instr.BTraceProbeNode;
import org.openjdk.btrace.instr.BTraceProbeSupport;
import org.openjdk.btrace.instr.BTraceTransformer;
import org.openjdk.btrace.instr.CallGraph;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Level;
import org.openjdk.btrace.instr.Location;
import org.openjdk.btrace.instr.MethodVerifier;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.OnProbe;
import org.openjdk.btrace.instr.ProbeRenameVisitor;
import org.openjdk.btrace.instr.ProbeUpgradeVisitor_1_2;
import org.openjdk.btrace.instr.TypeUtils;
import org.openjdk.btrace.instr.Verifier;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.FieldVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

public class BTraceProbePersisted
implements BTraceProbe {
    private static final Logger log = LoggerFactory.getLogger(BTraceProbePersisted.class);
    static final int MAGIC = -1160852790;
    private static final int VERSION = 2;
    final BTraceProbeSupport delegate;
    private final BTraceProbeFactory factory;
    private final DebugSupport debug;
    private final AtomicBoolean triedVerify = new AtomicBoolean(false);
    private final Map<String, Set<String>> calleeMap = new HashMap<String, Set<String>>();
    private volatile BTraceRuntime.Impl rt = null;
    private BTraceTransformer transformer;
    private byte[] fullData = null;
    private byte[] dataHolder = null;
    private boolean preverified;

    BTraceProbePersisted(BTraceProbeFactory f) {
        this(f, null);
    }

    private BTraceProbePersisted(BTraceProbeFactory f, BTraceProbeSupport delegate) {
        this.debug = new DebugSupport(f.getSettings());
        this.delegate = delegate != null ? delegate : new BTraceProbeSupport();
        this.factory = f;
        this.preverified = false;
    }

    private BTraceProbePersisted(BTraceProbeNode bpn) {
        this(bpn.factory, bpn.delegate);
        this.fullData = bpn.getFullBytecode();
        this.dataHolder = bpn.getDataHolderBytecode();
        BTraceProbePersisted.loadCalleeMap(bpn, this.calleeMap);
        this.preverified = true;
    }

    public static BTraceProbePersisted from(BTraceProbe bp) {
        return bp instanceof BTraceProbePersisted ? (BTraceProbePersisted)bp : new BTraceProbePersisted((BTraceProbeNode)bp);
    }

    private static void loadCalleeMap(BTraceProbeNode bpn, Map<String, Set<String>> cMap) {
        HashSet<Handler> roots = new HashSet<Handler>();
        for (OnMethod om : bpn.onmethods()) {
            roots.add(new Handler(om.getTargetName(), om.getTargetDescriptor()));
        }
        for (OnProbe op : bpn.onprobes()) {
            roots.add(new Handler(op.getTargetName(), op.getTargetDescriptor()));
        }
        for (Handler h : roots) {
            String rootKey = CallGraph.methodId(h.name, h.desc);
            Set cs = cMap.computeIfAbsent(rootKey, k -> new HashSet());
            for (BTraceMethodNode bmn : bpn.callees(h.name, h.desc)) {
                cs.add(CallGraph.methodId(bmn.name, bmn.desc));
            }
        }
    }

    private static String getClazz(OnMethod om) {
        String clzName = om.getClazz();
        if (om.isSubtypeMatcher()) {
            return "+" + om.getClazz();
        }
        if (om.isClassRegexMatcher()) {
            clzName = "/" + clzName + "/";
        }
        if (om.isClassAnnotationMatcher()) {
            clzName = "@" + clzName;
        }
        return clzName;
    }

    private static String getMethod(OnMethod om) {
        String mName = om.getMethod();
        if (om.isMethodRegexMatcher()) {
            mName = "/" + mName + "/";
        }
        if (om.isMethodAnnotationMatcher()) {
            mName = "@" + mName;
        }
        return mName;
    }

    public void read(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        switch (version) {
            case 1: {
                this.read_1(dis);
                break;
            }
            case 2: {
                this.read_2(dis);
                break;
            }
            default: {
                throw new IOException("Unsupported version for persisted probe: " + version);
            }
        }
    }

    private void read_1(DataInputStream dis) throws IOException {
        this.delegate.setClassName(dis.readUTF());
        this.readServices(dis);
        this.readOnMethods(dis);
        this.readOnProbes(dis);
        this.readCallees(dis);
        this.readDataHolderClass(dis);
        this.readFullData(dis);
        this.upgradeBytecode();
    }

    private void read_2(DataInputStream dis) throws IOException {
        this.delegate.setClassName(dis.readUTF());
        this.readServices(dis);
        this.readOnMethods(dis);
        this.readOnProbes(dis);
        this.readCallees(dis);
        this.readDataHolderClass(dis);
        this.readFullData(dis);
    }

    public void write(DataOutputStream dos) {
        try {
            dos.writeInt(-1160852790);
            dos.writeInt(2);
            dos.writeUTF(this.getClassName(true));
            this.writeServices(dos);
            this.writeOnMethods(dos);
            this.writeOnProbes(dos);
            this.writeCallees(dos);
            this.writeDataHolderClass(dos);
            this.writeFullData(dos);
        }
        catch (IOException e) {
            log.debug("Failed to write probe {}", (Object)this.getClassName(), (Object)e);
        }
    }

    private void readServices(DataInputStream dis) throws IOException {
        int num = dis.readInt();
        for (int i = 0; i < num; ++i) {
            this.delegate.addServiceField(dis.readUTF(), dis.readUTF());
        }
    }

    private void readOnMethods(DataInputStream dis) throws IOException {
        int num = dis.readInt();
        for (int i = 0; i < num; ++i) {
            OnMethod om = new OnMethod();
            om.setClazz(dis.readUTF());
            om.setMethod(dis.readUTF());
            om.setExactTypeMatch(dis.readBoolean());
            om.setTargetDescriptor(dis.readUTF());
            om.setTargetName(dis.readUTF());
            om.setType(dis.readUTF());
            om.setClassNameParameter(dis.readInt());
            om.setDurationParameter(dis.readInt());
            om.setMethodParameter(dis.readInt());
            om.setReturnParameter(dis.readInt());
            om.setSelfParameter(dis.readInt());
            om.setTargetInstanceParameter(dis.readInt());
            om.setTargetMethodOrFieldParameter(dis.readInt());
            om.setMethodFqn(dis.readBoolean());
            om.setTargetMethodOrFieldFqn(dis.readBoolean());
            om.setSamplerKind(Sampled.Sampler.valueOf(dis.readUTF()));
            om.setSamplerMean(dis.readInt());
            om.setLevel(dis.readBoolean() ? Level.fromString(dis.readUTF()) : null);
            Location loc = new Location();
            loc.setValue(Kind.valueOf(dis.readUTF()));
            loc.setWhere(Where.valueOf(dis.readUTF()));
            loc.setClazz(dis.readBoolean() ? dis.readUTF() : null);
            loc.setField(dis.readBoolean() ? dis.readUTF() : null);
            loc.setMethod(dis.readBoolean() ? dis.readUTF() : null);
            loc.setType(dis.readBoolean() ? dis.readUTF() : null);
            loc.setLine(dis.readInt());
            om.setLocation(loc);
            this.delegate.addOnMethod(om);
        }
    }

    private void readOnProbes(DataInputStream dis) throws IOException {
        int num = dis.readInt();
        for (int i = 0; i < num; ++i) {
            OnProbe op = new OnProbe();
            op.setNamespace(dis.readUTF());
            op.setName(dis.readUTF());
            op.setTargetDescriptor(dis.readUTF());
            op.setTargetName(dis.readUTF());
            op.setClassNameParameter(dis.readInt());
            op.setDurationParameter(dis.readInt());
            op.setMethodParameter(dis.readInt());
            op.setReturnParameter(dis.readInt());
            op.setSelfParameter(dis.readInt());
            op.setTargetInstanceParameter(dis.readInt());
            op.setTargetMethodOrFieldParameter(dis.readInt());
            op.setMethodFqn(dis.readBoolean());
            op.setTargetMethodOrFieldFqn(dis.readBoolean());
            this.delegate.addOnProbe(op);
        }
    }

    private void readFullData(DataInputStream dis) throws IOException {
        int fullDataLen = dis.readInt();
        this.fullData = new byte[fullDataLen];
        dis.readFully(this.fullData);
    }

    private void readDataHolderClass(DataInputStream dis) throws IOException {
        int holderLen = dis.readInt();
        this.dataHolder = new byte[holderLen];
        dis.readFully(this.dataHolder);
        if (this.dataHolder.length > 0 && this.isClassRenamed()) {
            this.dataHolder = ProbeRenameVisitor.rename(this.getClassName(), this.dataHolder);
        }
    }

    private void readCallees(DataInputStream dis) throws IOException {
        int cnt = dis.readInt();
        for (int i = 0; i < cnt; ++i) {
            String from = dis.readUTF();
            Set calleeSet = this.calleeMap.computeIfAbsent(from, k -> new HashSet());
            int callees = dis.readInt();
            for (int j = 0; j < callees; ++j) {
                String to = dis.readUTF();
                calleeSet.add(to);
            }
        }
    }

    private void writeServices(DataOutputStream dos) throws IOException {
        Map<String, String> svcFields = this.delegate.serviceFields();
        dos.writeInt(svcFields.size());
        for (Map.Entry<String, String> e : svcFields.entrySet()) {
            dos.writeUTF(e.getKey());
            dos.writeUTF(e.getValue());
        }
    }

    private void writeOnMethods(DataOutputStream dos) throws IOException {
        Collection<OnMethod> onMethods = this.delegate.getOnMethods();
        int cnt = onMethods.size();
        dos.writeInt(cnt);
        for (OnMethod om : onMethods) {
            dos.writeUTF(BTraceProbePersisted.getClazz(om));
            dos.writeUTF(BTraceProbePersisted.getMethod(om));
            dos.writeBoolean(om.isExactTypeMatch());
            dos.writeUTF(om.getTargetDescriptor());
            dos.writeUTF(om.getTargetName());
            dos.writeUTF(om.getType());
            dos.writeInt(om.getClassNameParameter());
            dos.writeInt(om.getDurationParameter());
            dos.writeInt(om.getMethodParameter());
            dos.writeInt(om.getReturnParameter());
            dos.writeInt(om.getSelfParameter());
            dos.writeInt(om.getTargetInstanceParameter());
            dos.writeInt(om.getTargetMethodOrFieldParameter());
            dos.writeBoolean(om.isMethodFqn());
            dos.writeBoolean(om.isTargetMethodOrFieldFqn());
            dos.writeUTF(om.getSamplerKind().name());
            dos.writeInt(om.getSamplerMean());
            dos.writeBoolean(om.getLevel() != null);
            if (om.getLevel() != null) {
                dos.writeUTF(om.getLevel().getValue().toString());
            }
            Location loc = om.getLocation();
            dos.writeUTF(loc.getValue().name());
            dos.writeUTF(loc.getWhere().name());
            dos.writeBoolean(loc.getClazz() != null);
            if (loc.getClazz() != null) {
                dos.writeUTF(loc.getClazz());
            }
            dos.writeBoolean(loc.getField() != null);
            if (loc.getField() != null) {
                dos.writeUTF(loc.getField());
            }
            dos.writeBoolean(loc.getMethod() != null);
            if (loc.getMethod() != null) {
                dos.writeUTF(loc.getMethod());
            }
            dos.writeBoolean(loc.getType() != null);
            if (loc.getType() != null) {
                dos.writeUTF(loc.getType());
            }
            dos.writeInt(loc.getLine());
        }
    }

    private void writeOnProbes(DataOutputStream dos) throws IOException {
        Collection<OnProbe> onProbes = this.delegate.getOnProbes();
        int cnt = onProbes.size();
        dos.writeInt(cnt);
        for (OnProbe op : onProbes) {
            dos.writeUTF(op.getNamespace());
            dos.writeUTF(op.getName());
            dos.writeUTF(op.getTargetDescriptor());
            dos.writeUTF(op.getTargetName());
            dos.writeInt(op.getClassNameParameter());
            dos.writeInt(op.getDurationParameter());
            dos.writeInt(op.getMethodParameter());
            dos.writeInt(op.getReturnParameter());
            dos.writeInt(op.getSelfParameter());
            dos.writeInt(op.getTargetInstanceParameter());
            dos.writeInt(op.getTargetMethodOrFieldParameter());
            dos.writeBoolean(op.isMethodFqn());
            dos.writeBoolean(op.isTargetMethodOrFieldFqn());
        }
    }

    private void writeFullData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.fullData.length);
        dos.write(this.fullData);
    }

    private void writeDataHolderClass(DataOutputStream dos) throws IOException {
        dos.writeInt(this.dataHolder.length);
        dos.write(this.dataHolder);
    }

    private void writeCallees(DataOutputStream dos) throws IOException {
        int cnt = 0;
        for (Set<String> set : this.calleeMap.values()) {
            if (set.isEmpty()) continue;
            ++cnt;
        }
        dos.writeInt(cnt);
        for (Map.Entry entry : this.calleeMap.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            dos.writeUTF((String)entry.getKey());
            dos.writeInt(((Set)entry.getValue()).size());
            for (String c : (Set)entry.getValue()) {
                dos.writeUTF(c);
            }
        }
    }

    @Override
    public Collection<OnMethod> getApplicableHandlers(BTraceClassReader cr) {
        return this.delegate.getApplicableHandlers(cr);
    }

    @Override
    public byte[] getFullBytecode() {
        return this.fullData;
    }

    @Override
    public byte[] getDataHolderBytecode() {
        return this.dataHolder;
    }

    @Override
    public String getClassName() {
        return this.delegate.getClassName(false);
    }

    @Override
    public String getClassName(boolean internal) {
        return this.delegate.getClassName(internal);
    }

    @Override
    public boolean isClassRenamed() {
        return this.delegate.isClassRenamed();
    }

    @Override
    public boolean isTransforming() {
        return this.delegate.isTransforming();
    }

    @Override
    public boolean isVerified() {
        if (this.factory.getSettings().isTrusted()) {
            return true;
        }
        if (this.triedVerify.compareAndSet(false, true)) {
            try {
                this.verifyBytecode();
                return true;
            }
            catch (VerifierException e) {
                log.debug("Class '{}' verification failed", (Object)this.getClassName(), (Object)e);
            }
        }
        return false;
    }

    @Override
    public void notifyTransform(String className) {
        if (this.rt != null && this.factory.getSettings().isTrackRetransforms()) {
            this.rt.send(new RetransformClassNotification(className.replace('/', '.')));
        }
    }

    @Override
    public Iterable<OnMethod> onmethods() {
        return this.delegate.onmethods();
    }

    public Collection<OnMethod> getOnMethods() {
        return this.delegate.getOnMethods();
    }

    @Override
    public Iterable<OnProbe> onprobes() {
        return this.delegate.onprobes();
    }

    @Override
    public Class<?> register(BTraceRuntime.Impl rt, BTraceTransformer t) {
        byte[] code = this.dataHolder;
        if (this.debug.isDumpClasses()) {
            this.debug.dumpClass(this.delegate.getClassName(true) + "_bcp", code);
        }
        Class<?> clz = this.delegate.defineClass(rt, code);
        t.register(this);
        this.transformer = t;
        this.rt = rt;
        return clz;
    }

    @Override
    public void unregister() {
        if (this.transformer != null && this.isTransforming()) {
            if (log.isDebugEnabled()) {
                log.debug("onExit: removing transformer for {}", (Object)this.getClassName());
            }
            this.transformer.unregister(this);
        }
        this.rt = null;
    }

    @Override
    public boolean willInstrument(Class<?> clz) {
        return this.delegate.willInstrument(clz);
    }

    @Override
    public void checkVerified() {
        if (!this.preverified) {
            this.isVerified();
        }
    }

    @Override
    public void copyHandlers(final ClassVisitor copyingVisitor) {
        ClassReader cr = new ClassReader(this.fullData);
        final HashSet<String> copiedMethods = new HashSet<String>();
        for (OnMethod om : this.onmethods()) {
            if (!om.isCalled()) continue;
            String mid = CallGraph.methodId(om.getTargetName(), om.getTargetDescriptor());
            copiedMethods.add(mid);
            Set<String> callees = this.calleeMap.get(mid);
            if (callees == null) continue;
            copiedMethods.addAll((Collection)this.calleeMap.get(mid));
        }
        cr.accept(new ClassVisitor(589824){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                copyingVisitor.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                String mid = CallGraph.methodId(name, desc);
                if (copiedMethods.contains(mid)) {
                    return copyingVisitor.visitMethod(10, InstrumentUtils.getActionPrefix(BTraceProbePersisted.this.getClassName(true)) + name, desc.replace("Lorg/openjdk/btrace/core/types/AnyType;", "Ljava/lang/Object;"), signature != null ? signature.replace("Lorg/openjdk/btrace/core/types/AnyType;", "Ljava/lang/Object;") : null, exceptions);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        }, 0);
    }

    @Override
    public void applyArgs(ArgsMap argsMap) {
        this.delegate.applyArgs(argsMap);
    }

    @Override
    public BTraceRuntime.Impl getRuntime() {
        return this.rt;
    }

    private void upgradeBytecode() {
        this.fullData = ProbeUpgradeVisitor_1_2.upgrade(new ClassReader(this.fullData));
        this.dataHolder = ProbeUpgradeVisitor_1_2.upgrade(new ClassReader(this.dataHolder));
    }

    private void verifyBytecode() throws VerifierException {
        ClassReader cr = new ClassReader(this.fullData);
        cr.accept(new ClassVisitor(589824){
            private String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ((access & 0x200) != 0 || (access & 0x4000) != 0) {
                    Verifier.reportError("btrace.program.should.be.class");
                }
                if ((access & 1) == 0) {
                    Verifier.reportError("class.should.be.public", name);
                }
                if (!superName.equals("java/lang/Object")) {
                    Verifier.reportError("object.superclass.required", superName);
                }
                if (interfaces != null && interfaces.length > 0) {
                    Verifier.reportError("no.interface.implementation");
                }
                this.className = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (this.className.equals(outerName)) {
                    Verifier.reportError("no.nested.class");
                }
            }

            @Override
            public void visitOuterClass(String s, String s1, String s2) {
                Verifier.reportError("no.outer.class");
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String sig, Object dflt) {
                if ((access & 8) == 0) {
                    Verifier.reportError("agent.no.instance.variables", name);
                }
                return super.visitField(access, name, desc, sig, dflt);
            }

            @Override
            public MethodVisitor visitMethod(int access, String methodName, String desc, String sig, String[] exceptions) {
                if ((access & 0x20) != 0) {
                    Verifier.reportError("no.synchronized.methods", TypeUtils.descriptorToSimplified(desc, this.className, methodName));
                }
                if (!methodName.equals("<init>") && (access & 8) == 0) {
                    Verifier.reportError("no.instance.method", TypeUtils.descriptorToSimplified(desc, this.className, methodName));
                }
                if (methodName.equals("<clinit>")) {
                    return super.visitMethod(access, methodName, desc, sig, exceptions);
                }
                return new MethodVisitor(589824, super.visitMethod(access, methodName, desc, sig, exceptions)){
                    private final Map<Label, Label> labels;
                    {
                        this.labels = new HashMap<Label, Label>();
                    }

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (opcode == 181) {
                            Verifier.reportError("no.assignment");
                        }
                        if (opcode == 179 && !owner.equals(className)) {
                            Verifier.reportError("no.assignment");
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: {
                                Verifier.reportError("no.assignment");
                                break;
                            }
                            case 191: {
                                Verifier.reportError("no.throw");
                                break;
                            }
                            case 194: 
                            case 195: {
                                Verifier.reportError("no.synchronized.blocks");
                            }
                        }
                        super.visitInsn(opcode);
                    }

                    @Override
                    public void visitIntInsn(int opcode, int operand) {
                        if (opcode == 188) {
                            Verifier.reportError("no.array.creation");
                        }
                        super.visitIntInsn(opcode, operand);
                    }

                    @Override
                    public void visitJumpInsn(int opcode, Label label) {
                        if (this.labels.get(label) != null) {
                            Verifier.reportError("no.loops");
                        }
                        super.visitJumpInsn(opcode, label);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
                        switch (opcode) {
                            case 182: {
                                if (MethodVerifier.isPrimitiveWrapper(owner) && MethodVerifier.isUnboxMethod(name) || owner.equals("java/lang/StringBuilder") || owner.equals("java/lang/ThreadLocal") || owner.equals("org/openjdk/btrace/runtime/BTraceRuntimeAccess") || owner.equals("org/openjdk/btrace/runtime/BTraceRuntimeImplBase") || BTraceProbePersisted.this.delegate.isServiceType(owner)) break;
                                Verifier.reportError("no.method.calls", owner + "." + name + desc);
                                break;
                            }
                            case 185: {
                                Verifier.reportError("no.method.calls", owner + "." + name + desc);
                                break;
                            }
                            case 183: {
                                if (owner.equals("java/lang/Object") && name.equals("<init>") || owner.equals("java/lang/StringBuilder") || owner.equals("java/lang/ThreadLocal") || BTraceProbePersisted.this.delegate.isServiceType(owner)) break;
                                Verifier.reportError("no.method.calls", owner + "." + name + desc);
                                break;
                            }
                            case 184: {
                                if (owner.startsWith("org/openjdk/btrace/") || owner.equals(className) || "valueOf".equals(name) && MethodVerifier.isPrimitiveWrapper(owner)) break;
                                Verifier.reportError("no.method.calls", owner + "." + name + desc);
                            }
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itfc);
                    }

                    @Override
                    public void visitMultiANewArrayInsn(String desc, int dims) {
                        Verifier.reportError("no.array.creation");
                    }

                    @Override
                    public void visitTypeInsn(int opcode, String desc) {
                        if (opcode == 189) {
                            Verifier.reportError("no.array.creation", desc);
                        }
                        if (opcode == 187 && !desc.equals("java/lang/StringBuilder") && !BTraceProbePersisted.this.delegate.isServiceType(desc)) {
                            Verifier.reportError("no.new.object", desc);
                        }
                        super.visitTypeInsn(opcode, desc);
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (opcode == 169) {
                            Verifier.reportError("no.try");
                        }
                        super.visitVarInsn(opcode, var);
                    }
                };
            }
        }, 6);
    }

    private static final class Handler {
        private final String name;
        private final String desc;

        public Handler(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode(this.name);
            hash = 29 * hash + Objects.hashCode(this.desc);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Handler other = (Handler)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.desc, other.desc);
        }
    }
}

