/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.ClassFilter;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.OnProbe;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.BTraceRuntimeAccess;

public final class BTraceProbeSupport {
    private static final Logger log = LoggerFactory.getLogger(BTraceProbeSupport.class);
    private final List<OnMethod> onMethods;
    private final List<OnProbe> onProbes;
    private final Map<String, String> serviceFields;
    private final Object filterLock = new Object();
    private volatile ClassFilter filter;
    private boolean trustedScript = false;
    private boolean classRenamed = false;
    private String className;
    private String origName;

    BTraceProbeSupport() {
        this.onMethods = new ArrayList<OnMethod>();
        this.onProbes = new ArrayList<OnProbe>();
        this.serviceFields = new HashMap<String, String>();
    }

    void setClassName(String name) {
        this.origName = name;
        String clientName = BTraceRuntimeAccess.getClientName(name);
        this.className = clientName != null ? clientName : name;
        this.classRenamed = !this.className.equals(name);
    }

    String getClassName(boolean internal) {
        return internal ? this.className : this.className.replace("/", ".");
    }

    String getOrigName() {
        return this.origName;
    }

    boolean isClassRenamed() {
        return this.classRenamed;
    }

    String translateOwner(String owner) {
        if (owner.equals(this.origName)) {
            return this.getClassName(true);
        }
        return owner;
    }

    boolean isTransforming() {
        return this.onMethods.size() > 0;
    }

    Collection<OnMethod> getApplicableHandlers(BTraceClassReader cr) {
        ArrayList<OnMethod> applicables = new ArrayList<OnMethod>(this.onMethods.size());
        String targetName = cr.getJavaClassName();
        block0: for (OnMethod om : this.onMethods) {
            Pattern p;
            String probeClass = om.getClazz();
            if (probeClass == null || probeClass.isEmpty()) continue;
            if (probeClass.equals(targetName)) {
                applicables.add(om);
                continue;
            }
            if (om.isClassRegexMatcher() && !om.isClassAnnotationMatcher() && (p = Pattern.compile(probeClass)).matcher(targetName).matches()) {
                applicables.add(om);
                continue;
            }
            if (om.isClassAnnotationMatcher()) {
                Collection<String> annoTypes = cr.getAnnotationTypes();
                if (om.isClassRegexMatcher()) {
                    Pattern p2 = Pattern.compile(probeClass);
                    for (String annoType : annoTypes) {
                        if (!p2.matcher(annoType).matches()) continue;
                        applicables.add(om);
                        continue block0;
                    }
                } else if (annoTypes.contains(probeClass)) {
                    applicables.add(om);
                    continue;
                }
            }
            if (!om.isSubtypeMatcher() || !ClassFilter.isSubTypeOf(cr.getClassName(), cr.getClassLoader(), probeClass)) continue;
            applicables.add(om);
        }
        return applicables;
    }

    Collection<OnMethod> getOnMethods() {
        return Collections.unmodifiableCollection(this.onMethods);
    }

    Collection<OnProbe> getOnProbes() {
        return Collections.unmodifiableCollection(this.onProbes);
    }

    Iterable<OnMethod> onmethods() {
        return () -> Collections.unmodifiableCollection(this.onMethods).iterator();
    }

    Iterable<OnProbe> onprobes() {
        return () -> this.onProbes.iterator();
    }

    Map<String, String> serviceFields() {
        return Collections.unmodifiableMap(this.serviceFields);
    }

    boolean isServiceType(String typeName) {
        return this.serviceFields.containsValue(typeName);
    }

    boolean isFieldInjected(String name) {
        return this.serviceFields.containsKey(name);
    }

    void addOnMethod(OnMethod om) {
        this.onMethods.add(om);
    }

    void addOnProbe(OnProbe op) {
        this.onProbes.add(op);
    }

    void addServiceField(String fldName, String svcType) {
        this.serviceFields.put(fldName, svcType);
    }

    boolean willInstrument(Class clz) {
        return this.getClassFilter().isCandidate(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassFilter getClassFilter() {
        Object object = this.filterLock;
        synchronized (object) {
            if (this.filter == null) {
                this.filter = new ClassFilter(this.onmethods());
            }
            return this.filter;
        }
    }

    void setTrusted() {
        this.trustedScript = true;
    }

    boolean isTrusted() {
        return this.trustedScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> defineClass(BTraceRuntime.Impl rt, byte[] code) {
        boolean enteredHere = BTraceRuntime.enter();
        try {
            BTraceRuntime.leave();
            if (log.isDebugEnabled()) {
                log.debug("about to defineClass {}", (Object)this.getClassName(false));
            }
            Class<?> clz = rt.defineClass(code, this.isTransforming());
            if (log.isDebugEnabled()) {
                log.debug("defineClass succeeded for {}", (Object)this.getClassName(false));
            }
            Class<?> clazz = clz;
            return clazz;
        }
        finally {
            if (!enteredHere) {
                BTraceRuntime.enter();
            }
        }
    }

    void applyArgs(ArgsMap argsMap) {
        for (OnMethod om : this.onMethods) {
            om.applyArgs(argsMap);
        }
    }

    public String toString() {
        return "BTraceProbeSupport{onMethods=" + this.onMethods + ", onProbes=" + this.onProbes + ", trustedScript=" + this.trustedScript + ", serviceFields=" + this.serviceFields + '}';
    }
}

