/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import org.openjdk.btrace.instr.ClassInfo;
import org.openjdk.btrace.libs.org.jctools.maps.NonBlockingHashMap;
import org.openjdk.btrace.libs.org.jctools.maps.NonBlockingIdentityHashMap;

public final class ClassCache {
    private final Map<ClassLoaderReference, ClassLoaderReference> loaderRefs = new NonBlockingIdentityHashMap();
    private final ReferenceQueue<ClassLoader> cleanupQueue = new ReferenceQueue();
    private final ConcurrentMap<CacheKey, ConcurrentMap<ClassInfo.ClassName, ClassInfo>> cacheMap = new NonBlockingHashMap();
    private final ConcurrentMap<ClassInfo.ClassName, ClassInfo> bootstrapInfos = new NonBlockingHashMap(500);
    private final Timer cleanupTimer = new Timer(true);

    public static ClassCache getInstance() {
        return Singleton.INSTANCE;
    }

    ClassCache(long cleanupPeriod) {
        this.cleanupTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ClassLoaderReference ref = null;
                while ((ref = (ClassLoaderReference)ClassCache.this.cleanupQueue.poll()) != null) {
                    ClassCache.this.cacheMap.remove(ref.key);
                    ClassCache.this.loaderRefs.remove(ref);
                }
            }
        }, cleanupPeriod, cleanupPeriod);
    }

    public ClassInfo get(Class<?> clz) {
        return this.get(clz.getClassLoader(), clz.getName());
    }

    public ClassInfo get(ClassLoader cl, String className) {
        return this.get(cl, new ClassInfo.ClassName(className));
    }

    ClassInfo get(ClassLoader cl, ClassInfo.ClassName className) {
        ConcurrentMap<ClassInfo.ClassName, ClassInfo> infos = this.getInfos(cl);
        return infos.computeIfAbsent(className, k -> new ClassInfo(this, cl, (ClassInfo.ClassName)k));
    }

    ConcurrentMap<ClassInfo.ClassName, ClassInfo> getInfos(ClassLoader cl) {
        if (cl == null) {
            return this.bootstrapInfos;
        }
        boolean[] rslt = new boolean[]{false};
        ConcurrentMap infos = this.cacheMap.computeIfAbsent(ClassCache.getCacheKey(cl), k -> {
            rslt[0] = true;
            return new NonBlockingHashMap(500);
        });
        if (rslt[0]) {
            ClassLoaderReference ref = new ClassLoaderReference(cl, this.cleanupQueue);
            this.loaderRefs.put(ref, ref);
        }
        return infos;
    }

    private static CacheKey getCacheKey(ClassLoader cl) {
        return new CacheKey(cl.getClass().getName(), System.identityHashCode(cl));
    }

    int getSize() {
        return this.cacheMap.size();
    }

    private static final class Singleton {
        private static final ClassCache INSTANCE = new ClassCache(5000L);

        private Singleton() {
        }
    }

    private static final class ClassLoaderReference
    extends PhantomReference<ClassLoader> {
        final CacheKey key;

        public ClassLoaderReference(ClassLoader referent, ReferenceQueue<? super ClassLoader> q) {
            super(referent, q);
            this.key = ClassCache.getCacheKey(referent);
        }
    }

    private static final class CacheKey {
        public final String name;
        public final int id;
        private final int hashCode;

        public CacheKey(String name, int id) {
            this.name = name;
            this.id = id;
            this.hashCode = Objects.hash(name, id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.id == cacheKey.id && this.name.equals(cacheKey.name);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

