/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.libs.org.objectweb.asm.Handle;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

class StackTrackingMethodVisitor
extends MethodVisitor {
    private final State state;
    private final Map<Label, Collection<Label>> tryCatchStart = new HashMap<Label, Collection<Label>>();
    private final Map<Label, Collection<Label>> tryCatchEnd = new HashMap<Label, Collection<Label>>();
    private final Set<Label> effectiveHandlers = new HashSet<Label>();
    private final Collection<Label> handlers = new ArrayList<Label>();
    private final Set<Label> visitedLabels = new HashSet<Label>();

    public StackTrackingMethodVisitor(MethodVisitor mv, String className, String desc, boolean isStatic) {
        super(589824, mv);
        Type[] args = Type.getArgumentTypes(desc);
        this.state = new State(isStatic ? null : new InstanceItem(Type.getObjectType(className), new StackItem[0]), args);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(this.state.fState.maxStack, this.state.fState.maxVars);
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int i) {
        super.visitMultiANewArrayInsn(string, i);
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
        this.state.pop();
        super.visitLookupSwitchInsn(label, ints, labels);
    }

    @Override
    public void visitTableSwitchInsn(int i, int i1, Label label, Label ... labels) {
        this.state.pop();
        super.visitTableSwitchInsn(i, i1, label, labels);
    }

    @Override
    public void visitLdcInsn(Object o) {
        ConstantItem ci = new ConstantItem(o, new StackItem[0]);
        this.state.push(ci);
        if (o instanceof Long || o instanceof Double) {
            this.state.push(ci);
        }
        super.visitLdcInsn(o);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.state.pop();
                this.state.branch(label);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.state.pop();
                this.state.pop();
                this.state.branch(label);
                break;
            }
            case 167: 
            case 168: {
                this.state.branch(label);
                this.state.reset();
            }
        }
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string1, Handle handle, Object ... os) {
        super.visitInvokeDynamicInsn(string, string1, handle, os);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        super.visitMethodInsn(opcode, owner, name, desc, itfc);
        ArrayList<StackItem> poppedArgs = new ArrayList<StackItem>();
        Type[] args = Type.getArgumentTypes(desc);
        Type ret = Type.getReturnType(desc);
        for (int i = args.length - 1; i >= 0; --i) {
            if (args[i].equals(Type.VOID_TYPE)) continue;
            switch (args[i].getSort()) {
                case 7: 
                case 8: {
                    this.state.pop();
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    poppedArgs.add(this.state.pop());
                }
            }
        }
        if (opcode != 184) {
            poppedArgs.add(this.state.pop());
        }
        if (!ret.equals(Type.VOID_TYPE)) {
            ResultItem sl = new ResultItem(owner, name, desc, ResultItem.Origin.METHOD, poppedArgs.toArray(new StackItem[0]));
            switch (ret.getSort()) {
                case 7: 
                case 8: {
                    this.state.push(sl);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    this.state.push(sl);
                }
            }
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Type t = Type.getType(desc);
        super.visitFieldInsn(opcode, owner, name, desc);
        ArrayList<StackItem> parents = new ArrayList<StackItem>();
        if (opcode == 181 || opcode == 179) {
            switch (t.getSort()) {
                case 7: 
                case 8: {
                    this.state.pop();
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    parents.add(this.state.pop());
                }
            }
        }
        if (opcode == 180 || opcode == 181) {
            parents.add(this.state.pop());
        }
        if (opcode == 180 || opcode == 178) {
            ResultItem sl = new ResultItem(owner, name, desc, ResultItem.Origin.FIELD, parents.toArray(new StackItem[0]));
            switch (t.getSort()) {
                case 7: 
                case 8: {
                    this.state.push(sl);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    this.state.push(sl);
                }
            }
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        switch (opcode) {
            case 187: {
                this.state.push(new InstanceItem(Type.getObjectType(type), new StackItem[0]));
                break;
            }
            case 189: {
                this.state.push(new InstanceItem(Type.getObjectType(type), this.state.pop()));
                break;
            }
            case 193: {
                this.state.push(new InstanceItem(Type.BOOLEAN_TYPE, this.state.pop()));
            }
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        switch (opcode) {
            case 21: 
            case 23: 
            case 25: {
                this.state.push(this.state.load(var));
                break;
            }
            case 22: 
            case 24: {
                StackItem sl = this.state.load(var);
                this.state.push(sl);
                this.state.push(sl);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                StackItem sl = this.state.pop();
                this.state.store(sl, var);
                break;
            }
            case 55: 
            case 57: {
                StackItem sl = this.state.pop();
                this.state.pop();
                this.state.store(sl, var);
                break;
            }
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        switch (opcode) {
            case 16: 
            case 17: {
                this.state.push(new ConstantItem(operand, new StackItem[0]));
                break;
            }
            case 188: {
                StackItem sl = this.state.pop();
                this.state.push(new InstanceItem(Constants.OBJECT_TYPE, sl));
                break;
            }
        }
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        switch (opcode) {
            case 1: {
                this.state.push(new ConstantItem((Object)null, new StackItem[0]));
                break;
            }
            case 3: {
                this.state.push(new ConstantItem(0, new StackItem[0]));
                break;
            }
            case 4: {
                this.state.push(new ConstantItem(1, new StackItem[0]));
                break;
            }
            case 5: {
                this.state.push(new ConstantItem(2, new StackItem[0]));
                break;
            }
            case 6: {
                this.state.push(new ConstantItem(3, new StackItem[0]));
                break;
            }
            case 7: {
                this.state.push(new ConstantItem(4, new StackItem[0]));
                break;
            }
            case 8: {
                this.state.push(new ConstantItem(5, new StackItem[0]));
                break;
            }
            case 2: {
                this.state.push(new ConstantItem(-1, new StackItem[0]));
                break;
            }
            case 11: {
                this.state.push(new ConstantItem(Float.valueOf(0.0f), new StackItem[0]));
                break;
            }
            case 12: {
                this.state.push(new ConstantItem(Float.valueOf(1.0f), new StackItem[0]));
                break;
            }
            case 13: {
                this.state.push(new ConstantItem(Float.valueOf(2.0f), new StackItem[0]));
                break;
            }
            case 9: {
                ConstantItem si = new ConstantItem(0L, new StackItem[0]);
                this.state.push(si);
                this.state.push(si);
                break;
            }
            case 10: {
                ConstantItem si = new ConstantItem(1L, new StackItem[0]);
                this.state.push(si);
                this.state.push(si);
                break;
            }
            case 14: {
                ConstantItem si = new ConstantItem(0.0, new StackItem[0]);
                this.state.push(si);
                this.state.push(si);
                break;
            }
            case 15: {
                ConstantItem si = new ConstantItem(1.0, new StackItem[0]);
                this.state.push(si);
                this.state.push(si);
                break;
            }
            case 50: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                Type t = null;
                if (ref.getKind() == StackItem.Kind.INSTANCE) {
                    t = ((InstanceItem)ref).getType();
                } else if (ref.getKind() == StackItem.Kind.RESULT) {
                    t = ((ResultItem)ref).getType();
                }
                this.state.push(new InstanceItem(t, ref, index));
                break;
            }
            case 46: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                this.state.push(new InstanceItem(Type.INT_TYPE, index, ref));
                break;
            }
            case 48: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                this.state.push(new InstanceItem(Type.FLOAT_TYPE, index, ref));
                break;
            }
            case 51: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                this.state.push(new InstanceItem(Type.BYTE_TYPE, index, ref));
                break;
            }
            case 52: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                this.state.push(new InstanceItem(Type.CHAR_TYPE, index, ref));
                break;
            }
            case 53: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                this.state.push(new InstanceItem(Type.SHORT_TYPE, index, ref));
                break;
            }
            case 47: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                InstanceItem sl = new InstanceItem(Type.LONG_TYPE, index, ref);
                this.state.push(sl);
                this.state.push(sl);
                break;
            }
            case 49: {
                StackItem index = this.state.pop();
                StackItem ref = this.state.pop();
                InstanceItem sl = new InstanceItem(Type.DOUBLE_TYPE, index, ref);
                this.state.push(sl);
                this.state.push(sl);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.state.pop();
                this.state.pop();
                this.state.pop();
                break;
            }
            case 80: 
            case 82: {
                this.state.pop();
                this.state.pop();
                this.state.pop();
                this.state.pop();
                break;
            }
            case 87: {
                this.state.pop();
                break;
            }
            case 88: {
                this.state.pop();
                this.state.pop();
                break;
            }
            case 89: {
                this.state.push(this.state.peek());
                break;
            }
            case 90: {
                StackItem x = this.state.pop();
                StackItem y = this.state.pop();
                this.state.push(x);
                this.state.push(y);
                this.state.push(x);
                break;
            }
            case 91: {
                StackItem x = this.state.pop();
                StackItem y = this.state.pop();
                StackItem z = this.state.pop();
                this.state.push(x);
                this.state.push(z);
                this.state.push(y);
                this.state.push(x);
                break;
            }
            case 92: {
                StackItem x = this.state.pop();
                StackItem y = this.state.peek();
                this.state.push(x);
                this.state.push(y);
                this.state.push(x);
                break;
            }
            case 93: {
                StackItem x2 = this.state.pop();
                StackItem x1 = this.state.pop();
                StackItem y = this.state.pop();
                this.state.push(x1);
                this.state.push(x2);
                this.state.push(y);
                this.state.push(x1);
                this.state.push(x2);
                break;
            }
            case 94: {
                StackItem x2 = this.state.pop();
                StackItem x1 = this.state.pop();
                StackItem y2 = this.state.pop();
                StackItem y1 = this.state.pop();
                this.state.push(x1);
                this.state.push(x2);
                this.state.push(y1);
                this.state.push(y2);
                this.state.push(x1);
                this.state.push(x2);
                break;
            }
            case 95: {
                StackItem x = this.state.pop();
                StackItem y = this.state.pop();
                this.state.push(x);
                this.state.push(y);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                StackItem x = this.state.pop();
                StackItem y = this.state.pop();
                this.state.push(new InstanceItem(Type.INT_TYPE, x, y));
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                StackItem x = this.state.pop();
                StackItem y = this.state.pop();
                this.state.push(new InstanceItem(Type.FLOAT_TYPE, x, y));
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                StackItem x = this.state.pop();
                this.state.pop();
                StackItem y = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.LONG_TYPE, x, y);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                StackItem x = this.state.pop();
                this.state.pop();
                StackItem y = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.DOUBLE_TYPE, x, y);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 133: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.LONG_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 134: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.FLOAT_TYPE, x);
                this.state.push(rslt);
                break;
            }
            case 145: {
                StackItem x = this.state.pop();
                HashSet<StackItem> parents = new HashSet<StackItem>(x.getParents());
                InstanceItem rslt = new InstanceItem(Type.BYTE_TYPE, parents.toArray(new StackItem[0]));
                this.state.push(rslt);
                break;
            }
            case 146: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.CHAR_TYPE, x);
                this.state.push(rslt);
                break;
            }
            case 147: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.SHORT_TYPE, x);
                this.state.push(rslt);
                break;
            }
            case 135: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.DOUBLE_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 136: {
                StackItem x = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.INT_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 137: {
                StackItem x = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.FLOAT_TYPE, x);
                this.state.push(rslt);
                break;
            }
            case 138: {
                StackItem x = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.DOUBLE_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 139: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.INT_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 140: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.LONG_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 141: {
                StackItem x = this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.DOUBLE_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 142: {
                StackItem x = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.INT_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 144: {
                StackItem x = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.FLOAT_TYPE, x);
                this.state.push(rslt);
                break;
            }
            case 143: {
                StackItem x = this.state.pop();
                this.state.pop();
                InstanceItem rslt = new InstanceItem(Type.LONG_TYPE, x);
                this.state.push(rslt);
                this.state.push(rslt);
                break;
            }
            case 148: {
                StackItem a = this.state.pop();
                StackItem b = this.state.pop();
                StackItem c = this.state.pop();
                StackItem d = this.state.pop();
                this.state.push(new InstanceItem(Type.INT_TYPE, a, b, c, d));
                break;
            }
            case 149: 
            case 150: {
                StackItem x = this.state.pop();
                StackItem y = this.state.pop();
                this.state.push(new InstanceItem(Type.INT_TYPE, x, y));
                break;
            }
            case 151: 
            case 152: {
                StackItem a = this.state.pop();
                StackItem b = this.state.pop();
                StackItem c = this.state.pop();
                StackItem d = this.state.pop();
                this.state.push(new InstanceItem(Type.INT_TYPE, a, b, c, d));
                break;
            }
            case 169: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                this.state.reset();
                break;
            }
            case 191: {
                for (Label l : this.effectiveHandlers) {
                    this.state.branch(l);
                }
                this.state.reset();
                break;
            }
            case 190: {
                HashSet<StackItem> parents = new HashSet<StackItem>(this.state.pop().getParents());
                this.state.push(new InstanceItem(Type.INT_TYPE, parents.toArray(new StackItem[0])));
                break;
            }
            case 194: 
            case 195: {
                this.state.pop();
            }
        }
    }

    @Override
    public void visitIincInsn(int var, int inc) {
        StackItem si = this.state.load(var);
        this.state.store(new InstanceItem(Type.INT_TYPE, si), var);
        super.visitIincInsn(var, inc);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        Collection labels = this.tryCatchStart.computeIfAbsent(start, k -> new ArrayList());
        labels.add(handler);
        this.addToMappedCollection(this.tryCatchStart, start, handler);
        this.addToMappedCollection(this.tryCatchEnd, end, handler);
        this.handlers.add(handler);
    }

    private void addToMappedCollection(Map<Label, Collection<Label>> map, Label l, Label handler) {
        Collection labels = map.computeIfAbsent(l, k -> new ArrayList());
        labels.add(handler);
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        Collection<Label> labels = this.tryCatchStart.get(label);
        if (labels != null) {
            this.effectiveHandlers.addAll(labels);
        } else {
            labels = this.tryCatchEnd.get(label);
            if (labels != null) {
                this.effectiveHandlers.removeAll(labels);
            }
            this.state.join(label);
            if (this.handlers.contains(label)) {
                this.state.push(new InstanceItem(Constants.THROWABLE_TYPE, new StackItem[0]));
            }
        }
        this.visitedLabels.add(label);
    }

    protected List<StackItem> getMethodParams(String desc, boolean isStatic) {
        Type[] argTypes = Type.getArgumentTypes(desc);
        ArrayList<StackItem> items = new ArrayList<StackItem>();
        Iterator it = this.state.fState.stack.iterator();
        for (int idx = argTypes.length - 1; it.hasNext() && idx >= 0; --idx) {
            Type t = argTypes[idx];
            items.add(0, (StackItem)it.next());
            if (!t.equals(Type.LONG_TYPE) && !t.equals(Type.DOUBLE_TYPE)) continue;
            it.next();
        }
        if (!isStatic && it.hasNext()) {
            items.add(0, (StackItem)it.next());
        }
        return items;
    }

    private final class State {
        private final Map<Label, Set<FrameState>> stateMap = new HashMap<Label, Set<FrameState>>();
        private FrameState fState;

        public State(InstanceItem receiver, Type[] args) {
            HashMap<Integer, StackItem> argMap = new HashMap<Integer, StackItem>();
            int index = 0;
            if (receiver != null) {
                argMap.put(index++, receiver);
            }
            for (Type t : args) {
                argMap.put(index++, new InstanceItem(t, new StackItem[0]));
                if (!t.equals(Type.LONG_TYPE) && !t.equals(Type.DOUBLE_TYPE)) continue;
                ++index;
            }
            this.fState = new FrameState(argMap);
        }

        public void branch(Label l) {
            if (StackTrackingMethodVisitor.this.visitedLabels.contains(l)) {
                return;
            }
            Set states = this.stateMap.computeIfAbsent(l, k -> new HashSet());
            states.add(this.fState.duplicate());
        }

        public void branch(Label l, Type throwable) {
            if (StackTrackingMethodVisitor.this.visitedLabels.contains(l)) {
                return;
            }
            Set states = this.stateMap.computeIfAbsent(l, k -> new HashSet());
            FrameState duplicated = this.fState.duplicate();
            duplicated.push(new InstanceItem(throwable, new StackItem[0]));
            states.add(duplicated);
        }

        public void join(Label l) {
            Set<FrameState> states = this.stateMap.remove(l);
            if (states != null) {
                FrameState s;
                if (this.fState.isEmpty() && !states.isEmpty() && !(s = states.iterator().next()).isEmpty()) {
                    this.fState = s;
                }
                for (FrameState fs : states) {
                    Iterator i1 = this.fState.stack.iterator();
                    Iterator i2 = fs.stack.iterator();
                    while (i1.hasNext()) {
                        if (i2.hasNext()) {
                            StackItem target = (StackItem)i1.next();
                            StackItem src = (StackItem)i2.next();
                            target.merge(src);
                            continue;
                        }
                        throw new IllegalStateException("Error merging simulated stack");
                    }
                    if (!i2.hasNext()) continue;
                    throw new IllegalStateException("Error merging simulated stack");
                }
            }
        }

        public StackItem peek() {
            return this.fState.peek();
        }

        public void push(StackItem sl) {
            this.fState.push(sl);
        }

        public StackItem pop() {
            return this.fState.pop();
        }

        public void store(StackItem sl, int index) {
            this.fState.store(sl, index);
        }

        public StackItem load(int index) {
            return this.fState.load(index);
        }

        public void reset() {
            this.fState.reset();
        }
    }

    private static final class FrameState {
        private final Map<Integer, StackItem> vars;
        private final Map<Integer, StackItem> args;
        private final Deque<StackItem> stack;
        private int maxStack;
        private int maxVars;

        FrameState(Map<Integer, StackItem> args) {
            this(new LinkedList<StackItem>(), null, args);
        }

        private FrameState(Deque<StackItem> s, Map<Integer, StackItem> v, Map<Integer, StackItem> args) {
            this.stack = new LinkedList<StackItem>(s);
            this.vars = v != null ? new HashMap<Integer, StackItem>(v) : new HashMap();
            this.args = new HashMap<Integer, StackItem>(args);
        }

        public StackItem peek() {
            return this.stack.peek();
        }

        public void push(StackItem sl) {
            this.stack.push(sl);
            this.maxStack = Math.max(this.stack.size(), this.maxStack);
        }

        public StackItem pop() {
            return this.stack.pop();
        }

        public void store(StackItem si, int index) {
            this.vars.put(index, si);
            this.updateMaxVars(si, index);
        }

        public StackItem load(int index) {
            StackItem si = this.vars.get(index);
            if (si == null) {
                si = this.args.get(index);
            }
            this.updateMaxVars(si, index);
            return si;
        }

        public FrameState duplicate() {
            return new FrameState(this.stack, this.vars, this.args);
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public void reset() {
            this.stack.clear();
            this.vars.clear();
        }

        private void updateMaxVars(StackItem si, int index) {
            if (si == null) {
                return;
            }
            int size = 1;
            switch (si.getKind()) {
                case INSTANCE: {
                    size = ((InstanceItem)si).getType().getSize();
                    break;
                }
                case RESULT: {
                    size = ((ResultItem)si).getType().getSize();
                    break;
                }
                case CONSTANT: {
                    Object val = ((ConstantItem)si).getValue();
                    if (!(val instanceof Double) && !(val instanceof Long)) break;
                    size = 2;
                    break;
                }
            }
            this.maxVars = Math.max(index + size, this.maxVars);
        }
    }

    public static class ResultItem
    extends StackItem {
        private final String owner;
        private final String name;
        private final String desc;
        private final Origin origin;

        public ResultItem(String owner, String name, String desc, Origin origin, StackItem ... parents) {
            super(parents);
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.origin = origin;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public Type getType() {
            return Type.getReturnType(this.desc);
        }

        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public StackItem.Kind getKind() {
            return StackItem.Kind.RESULT;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.owner != null ? this.owner.hashCode() : 0);
            hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 89 * hash + (this.desc != null ? this.desc.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResultItem other = (ResultItem)obj;
            if (!Objects.equals(this.owner, other.owner)) {
                return false;
            }
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.desc, other.desc);
        }

        public static enum Origin {
            FIELD,
            METHOD;

        }
    }

    public static class InstanceItem
    extends StackItem {
        private final Type t;

        public InstanceItem(Type t, StackItem ... parents) {
            super(parents);
            this.t = t;
        }

        public Type getType() {
            return this.t;
        }

        @Override
        public StackItem.Kind getKind() {
            return StackItem.Kind.INSTANCE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.t != null ? this.t.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceItem other = (InstanceItem)obj;
            return Objects.equals(this.t, other.t);
        }
    }

    public static class ConstantItem
    extends StackItem {
        private final Object val;

        public ConstantItem(Object val, StackItem ... parents) {
            super(parents);
            this.val = val;
        }

        public Object getValue() {
            return this.val;
        }

        @Override
        public StackItem.Kind getKind() {
            return StackItem.Kind.CONSTANT;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.val != null ? this.val.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstantItem other = (ConstantItem)obj;
            return Objects.equals(this.val, other.val);
        }
    }

    public static final class VariableItem
    extends StackItem {
        private final int var;

        public VariableItem(int var, StackItem ... parents) {
            super(parents);
            this.var = var;
        }

        public int getVar() {
            return this.var;
        }

        @Override
        public StackItem.Kind getKind() {
            return StackItem.Kind.VARIABLE;
        }

        public int hashCode() {
            int hash = 5;
            hash = 31 * hash + this.var;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableItem other = (VariableItem)obj;
            return this.var == other.var;
        }
    }

    public static abstract class StackItem {
        private final Set<StackItem> parents = new HashSet<StackItem>();

        public StackItem(StackItem ... parents) {
            this.parents.addAll(Arrays.asList(parents));
        }

        public final Set<StackItem> getParents() {
            return this.parents;
        }

        public final void merge(StackItem sl) {
            this.parents.addAll(sl.getParents());
        }

        public abstract Kind getKind();

        public static enum Kind {
            VARIABLE,
            CONSTANT,
            INSTANCE,
            RESULT;

        }
    }
}

