/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr.templates.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openjdk.btrace.core.annotations.Sampled;
import org.openjdk.btrace.instr.Assembler;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.instr.MethodTracker;
import org.openjdk.btrace.instr.templates.BaseTemplateExpander;
import org.openjdk.btrace.instr.templates.Template;
import org.openjdk.btrace.instr.templates.TemplateExpander;
import org.openjdk.btrace.instr.templates.TemplateExpanderVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.runtime.Interval;

public class MethodTrackingExpander
extends BaseTemplateExpander {
    public static final Template ENTRY = new Template("mc$entry", "()V");
    public static final Template DURATION = new Template("mc$dur", "()J");
    public static final Template TEST_SAMPLE = new Template("mc$test", "()V");
    public static final Template ELSE_SAMPLE = new Template("mc$else", "()V");
    public static final Template EXIT = new Template("mc$exit", "()V");
    public static final Template RESET = new Template("mc$reset", "()V");
    public static final String $TIMED = "timed";
    public static final String $MEAN = "mean";
    public static final String $SAMPLER = "sampler";
    public static final String $METHODID = "methodid";
    public static final String $LEVEL = "level";
    private static final String METHOD_COUNTER_CLASS = "org/openjdk/btrace/instr/MethodTracker";
    private final int methodId;
    private final Collection<Interval> levelIntervals = new ArrayList<Interval>();
    private final MethodInstrumentorHelper mHelper;
    private boolean isTimed = false;
    private boolean isSampled = false;
    private Sampled.Sampler samplerKind = Sampled.Sampler.None;
    private int samplerMean = -1;
    private int entryTsVar = Integer.MIN_VALUE;
    private int sHitVar = Integer.MIN_VALUE;
    private int durationVar = Integer.MIN_VALUE;
    private int globalLevelVar = Integer.MIN_VALUE;
    private boolean durationComputed = false;
    private Label elseLabel = null;
    private Label samplerLabel = null;

    public MethodTrackingExpander(int methodId, MethodInstrumentorHelper mHelper) {
        super(ENTRY, DURATION, TEST_SAMPLE, ELSE_SAMPLE, EXIT, RESET);
        this.methodId = methodId;
        this.mHelper = mHelper;
    }

    @Override
    protected void recordTemplate(Template t) {
        if (ENTRY.equals(t)) {
            Map<String, String> m = t.getTagMap();
            this.isTimed = m.containsKey($TIMED);
            String sKind = m.get($SAMPLER);
            String sMean = m.get($MEAN);
            String levelStr = m.get($LEVEL);
            if (levelStr != null && !levelStr.isEmpty()) {
                Interval itv = Interval.fromString(levelStr);
                this.levelIntervals.add(itv);
            }
            if (sKind != null) {
                if (this.samplerMean != 0) {
                    int mean;
                    int n = mean = sMean != null ? Integer.parseInt(sMean) : 10;
                    if (this.samplerKind != Sampled.Sampler.Const) {
                        this.samplerKind = Sampled.Sampler.valueOf(sKind);
                    }
                    if (this.samplerMean == -1) {
                        this.samplerMean = mean;
                    } else if (this.samplerMean > 0) {
                        this.samplerMean = Math.min(this.samplerMean, mean);
                    }
                    this.isSampled = this.samplerMean > 0;
                }
            } else {
                this.samplerMean = 0;
                this.isSampled = false;
            }
        }
    }

    @Override
    protected TemplateExpander.Result expandTemplate(TemplateExpanderVisitor v, Template t) {
        int mid;
        int localMethodId = this.methodId;
        String sMethodId = t.getTagMap().get($METHODID);
        if (sMethodId != null) {
            localMethodId = Integer.parseInt(sMethodId);
        }
        if (this.tryExpandEntry(t, mid = localMethodId, v) || this.tryExpandTest(t, mid, v) || this.tryExpandElse(t, v) || this.tryExpandDuration(t, v) || this.tryExpandExit(t, mid, v) || this.tryExpandReset(t, v)) {
            return TemplateExpander.Result.EXPANDED;
        }
        return TemplateExpander.Result.IGNORED;
    }

    private boolean tryExpandEntry(Template t, int mid, TemplateExpanderVisitor v) {
        if (ENTRY.equals(t)) {
            if (this.isSampled) {
                MethodTracker.registerCounter(mid, this.samplerMean);
                if (this.isTimed) {
                    v.expand(new TimingSamplerEntry(mid));
                } else {
                    v.expand(new SamplerEntry(mid));
                }
            } else if (this.isTimed) {
                v.expand(new TimingEntry());
            }
            return true;
        }
        return false;
    }

    private boolean tryExpandTest(Template t, int mid, TemplateExpanderVisitor v) {
        if (TEST_SAMPLE.equals(t)) {
            this.samplerLabel = new Label();
            boolean collectTime = t.getTagMap().containsKey($TIMED);
            boolean expanded = false;
            if (this.isSampled) {
                v.expand(new SamplerTest());
                if (this.isTimed && collectTime) {
                    v.expand(new TimingSamplerTest(mid));
                }
                expanded = true;
            } else if (this.isTimed && collectTime) {
                v.expand(new TimingTest());
                expanded = true;
            }
            if (expanded) {
                v.asm().label(this.samplerLabel);
                this.mHelper.insertFrameSameStack(this.samplerLabel);
            }
            this.samplerLabel = null;
            return true;
        }
        return false;
    }

    private boolean tryExpandElse(Template t, TemplateExpanderVisitor v) {
        if (ELSE_SAMPLE.equals(t)) {
            v.expand(new Else());
            return true;
        }
        return false;
    }

    private boolean tryExpandDuration(Template t, TemplateExpanderVisitor v) {
        if (DURATION.equals(t)) {
            v.expand(new Duration());
            return true;
        }
        return false;
    }

    private boolean tryExpandExit(Template t, int mid, TemplateExpanderVisitor v) {
        if (EXIT.equals(t)) {
            v.expand(new Exit(mid));
            return true;
        }
        return false;
    }

    private boolean tryExpandReset(Template t, TemplateExpanderVisitor v) {
        if (RESET.equals(t)) {
            this.entryTsVar = Integer.MIN_VALUE;
            this.sHitVar = Integer.MIN_VALUE;
            this.globalLevelVar = Integer.MIN_VALUE;
            this.durationComputed = false;
            return true;
        }
        return false;
    }

    @Override
    public void resetState() {
        this.durationComputed = false;
    }

    private Label addLevelChecks(TemplateExpanderVisitor e) {
        return this.addLevelChecks(e, null, null);
    }

    private Label addLevelChecks(TemplateExpanderVisitor e, Runnable initializer) {
        return this.addLevelChecks(e, null, initializer);
    }

    private Label addLevelChecks(TemplateExpanderVisitor e, Label skip) {
        return this.addLevelChecks(e, skip, null);
    }

    private Label addLevelChecks(TemplateExpanderVisitor e, Label skip, Runnable initializer) {
        Label skipTarget = null;
        if (!this.levelIntervals.isEmpty()) {
            Interval i;
            Assembler asm = new Assembler(e, this.mHelper);
            List<Interval> optimized = Interval.invert(this.levelIntervals);
            boolean generateBranch = true;
            if (optimized.size() == 1 && ((i = optimized.get(0)).isNone() || i.getA() == Integer.MIN_VALUE && i.getB() == -1)) {
                generateBranch = false;
            }
            if (generateBranch) {
                if (initializer != null) {
                    initializer.run();
                }
                skipTarget = skip != null ? skip : new Label();
                for (Interval i2 : optimized) {
                    Label nextCheck = new Label();
                    if (this.globalLevelVar == Integer.MIN_VALUE) {
                        asm.getStatic(e.getProbeClassName(true), "$btrace$$level", "I").dup();
                        this.globalLevelVar = e.storeAsNew();
                    } else {
                        asm.loadLocal(Type.INT_TYPE, this.globalLevelVar);
                    }
                    boolean stackConsumed = false;
                    if (i2.getA() > Integer.MIN_VALUE) {
                        stackConsumed = true;
                        if (i2.getA() == 0) {
                            asm.jump(155, nextCheck);
                        } else {
                            asm.ldc(i2.getA()).jump(161, nextCheck);
                        }
                    }
                    if (i2.getB() < Integer.MAX_VALUE) {
                        if (stackConsumed) {
                            asm.loadLocal(Type.INT_TYPE, this.globalLevelVar);
                        }
                        if (i2.getB() == 0) {
                            asm.jump(158, skipTarget);
                        } else {
                            asm.ldc(i2.getB()).jump(164, skipTarget);
                        }
                    } else {
                        Label l = new Label();
                        asm.label(l);
                        this.mHelper.insertFrameSameStack(l);
                        asm.jump(167, skipTarget);
                    }
                    asm.label(nextCheck);
                    this.mHelper.insertFrameSameStack(nextCheck);
                }
            }
        }
        return skipTarget;
    }

    private class Duration
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private Duration() {
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            if (!MethodTrackingExpander.this.durationComputed) {
                e.asm().ldc(0L);
            } else {
                e.asm().loadLocal(Type.LONG_TYPE, MethodTrackingExpander.this.durationVar);
            }
        }
    }

    private class Exit
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private final int mid;

        public Exit(int mid) {
            this.mid = mid;
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            if (MethodTrackingExpander.this.samplerKind == Sampled.Sampler.Adaptive) {
                Label l = new Label();
                e.asm().loadLocal(Type.INT_TYPE, MethodTrackingExpander.this.sHitVar).jump(153, l).ldc(this.mid).invokeStatic(MethodTrackingExpander.METHOD_COUNTER_CLASS, "updateEndTs", "(I)V").label(l);
                MethodTrackingExpander.this.mHelper.insertFrameSameStack(l);
            }
        }
    }

    private class Else
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private Else() {
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            if (MethodTrackingExpander.this.elseLabel != null) {
                e.asm().label(MethodTrackingExpander.this.elseLabel);
                MethodTrackingExpander.this.mHelper.insertFrameSameStack(MethodTrackingExpander.this.elseLabel);
                MethodTrackingExpander.this.elseLabel = null;
            }
        }
    }

    private class TimingTest
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private TimingTest() {
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            if (!MethodTrackingExpander.this.durationComputed) {
                MethodTrackingExpander.this.addLevelChecks(e, MethodTrackingExpander.this.samplerLabel);
                if (MethodTrackingExpander.this.entryTsVar != Integer.MIN_VALUE) {
                    e.asm().invokeStatic("java/lang/System", "nanoTime", "()J").loadLocal(Type.LONG_TYPE, MethodTrackingExpander.this.entryTsVar).sub(Type.LONG_TYPE);
                } else {
                    e.asm().ldc(0L);
                }
                e.asm().storeLocal(Type.LONG_TYPE, MethodTrackingExpander.this.durationVar);
                MethodTrackingExpander.this.durationComputed = true;
            }
        }
    }

    private class TimingSamplerTest
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private final int mid;

        public TimingSamplerTest(int mid) {
            this.mid = mid;
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            if (!MethodTrackingExpander.this.durationComputed) {
                if (MethodTrackingExpander.this.entryTsVar != Integer.MIN_VALUE) {
                    e.asm().ldc(this.mid).invokeStatic(MethodTrackingExpander.METHOD_COUNTER_CLASS, "getEndTs", "(I)J").loadLocal(Type.LONG_TYPE, MethodTrackingExpander.this.entryTsVar).sub(Type.LONG_TYPE);
                } else {
                    e.asm().ldc(0L);
                }
                e.asm().storeLocal(Type.LONG_TYPE, MethodTrackingExpander.this.durationVar);
                MethodTrackingExpander.this.durationComputed = true;
            }
        }
    }

    private class SamplerTest
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private SamplerTest() {
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            if (MethodTrackingExpander.this.sHitVar != Integer.MIN_VALUE) {
                MethodTrackingExpander.this.elseLabel = new Label();
                MethodTrackingExpander.this.addLevelChecks(e, MethodTrackingExpander.this.samplerLabel);
                e.asm().loadLocal(Type.INT_TYPE, MethodTrackingExpander.this.sHitVar).jump(153, MethodTrackingExpander.this.elseLabel);
            }
        }
    }

    private class TimingEntry
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private TimingEntry() {
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            Assembler asm = e.asm();
            if (MethodTrackingExpander.this.entryTsVar == Integer.MIN_VALUE) {
                if (MethodTrackingExpander.this.durationVar == Integer.MIN_VALUE) {
                    asm.ldc(0L);
                    MethodTrackingExpander.this.durationVar = e.storeAsNew();
                }
                Label skipTarget = MethodTrackingExpander.this.addLevelChecks(e, () -> {
                    asm.ldc(0L);
                    MethodTrackingExpander.this.entryTsVar = e.storeAsNew();
                });
                asm.invokeStatic("java/lang/System", "nanoTime", "()J");
                if (MethodTrackingExpander.this.entryTsVar == Integer.MIN_VALUE) {
                    MethodTrackingExpander.this.entryTsVar = e.storeAsNew();
                } else {
                    asm.storeLocal(Type.LONG_TYPE, MethodTrackingExpander.this.entryTsVar);
                }
                if (skipTarget != null) {
                    asm.label(skipTarget);
                    MethodTrackingExpander.this.mHelper.insertFrameSameStack(skipTarget);
                }
            }
        }
    }

    private class SamplerEntry
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private final int mid;

        public SamplerEntry(int mid) {
            this.mid = mid;
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            Assembler asm = e.asm();
            if (MethodTrackingExpander.this.sHitVar == Integer.MIN_VALUE) {
                Label skipTarget = MethodTrackingExpander.this.addLevelChecks(e, () -> {
                    if (MethodTrackingExpander.this.sHitVar == Integer.MIN_VALUE) {
                        asm.ldc(0);
                        MethodTrackingExpander.this.sHitVar = e.storeAsNew();
                    }
                });
                asm.ldc(this.mid);
                switch (MethodTrackingExpander.this.samplerKind) {
                    case Const: {
                        asm.invokeStatic(MethodTrackingExpander.METHOD_COUNTER_CLASS, "hit", "(I)Z");
                        break;
                    }
                    case Adaptive: {
                        asm.invokeStatic(MethodTrackingExpander.METHOD_COUNTER_CLASS, "hitAdaptive", "(I)Z");
                        break;
                    }
                }
                if (MethodTrackingExpander.this.sHitVar == Integer.MIN_VALUE) {
                    MethodTrackingExpander.this.sHitVar = e.storeAsNew();
                } else {
                    asm.storeLocal(Type.INT_TYPE, MethodTrackingExpander.this.sHitVar);
                }
                if (skipTarget != null) {
                    asm.label(skipTarget);
                    MethodTrackingExpander.this.mHelper.insertFrameSameStack(skipTarget);
                }
            }
        }
    }

    private class TimingSamplerEntry
    implements TemplateExpander.Consumer<TemplateExpanderVisitor> {
        private final int mid;

        public TimingSamplerEntry(int mid) {
            this.mid = mid;
        }

        @Override
        public void consume(TemplateExpanderVisitor e) {
            Assembler asm = e.asm();
            if (MethodTrackingExpander.this.durationVar == Integer.MIN_VALUE) {
                asm.ldc(0L);
                MethodTrackingExpander.this.durationVar = e.storeAsNew();
            }
            if (MethodTrackingExpander.this.sHitVar == Integer.MIN_VALUE && MethodTrackingExpander.this.entryTsVar == Integer.MIN_VALUE) {
                Label skipTarget = MethodTrackingExpander.this.addLevelChecks(e, () -> {
                    if (MethodTrackingExpander.this.entryTsVar == Integer.MIN_VALUE) {
                        asm.ldc(0L);
                        MethodTrackingExpander.this.entryTsVar = e.storeAsNew();
                    }
                    if (MethodTrackingExpander.this.sHitVar == Integer.MIN_VALUE) {
                        asm.ldc(0);
                        MethodTrackingExpander.this.sHitVar = e.storeAsNew();
                    }
                });
                asm.ldc(this.mid);
                switch (MethodTrackingExpander.this.samplerKind) {
                    case Const: {
                        asm.invokeStatic(MethodTrackingExpander.METHOD_COUNTER_CLASS, "hitTimed", "(I)J");
                        break;
                    }
                    case Adaptive: {
                        asm.invokeStatic(MethodTrackingExpander.METHOD_COUNTER_CLASS, "hitTimedAdaptive", "(I)J");
                        break;
                    }
                }
                asm.dup2();
                if (MethodTrackingExpander.this.entryTsVar == Integer.MIN_VALUE) {
                    MethodTrackingExpander.this.entryTsVar = e.storeAsNew();
                } else {
                    asm.storeLocal(Type.LONG_TYPE, MethodTrackingExpander.this.entryTsVar);
                }
                e.visitInsn(136);
                if (MethodTrackingExpander.this.sHitVar == Integer.MIN_VALUE) {
                    MethodTrackingExpander.this.sHitVar = e.storeAsNew();
                } else {
                    asm.storeLocal(Type.INT_TYPE, MethodTrackingExpander.this.sHitVar);
                }
                if (skipTarget != null) {
                    asm.label(skipTarget);
                    MethodTrackingExpander.this.mHelper.insertFrameSameStack(skipTarget);
                }
            }
        }
    }
}

