/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues;

import org.openjdk.btrace.libs.org.jctools.util.UnsafeAccess;
import org.openjdk.btrace.libs.org.jctools.util.UnsafeRefArrayAccess;

public class MpUnboundedXaddChunk<R, E> {
    public static final int NOT_USED = -1;
    private static final long PREV_OFFSET = UnsafeAccess.fieldOffset(MpUnboundedXaddChunk.class, (String)"prev");
    private static final long NEXT_OFFSET = UnsafeAccess.fieldOffset(MpUnboundedXaddChunk.class, (String)"next");
    private static final long INDEX_OFFSET = UnsafeAccess.fieldOffset(MpUnboundedXaddChunk.class, (String)"index");
    private final boolean pooled;
    private final E[] buffer;
    private volatile R prev;
    private volatile long index;
    private volatile R next;

    protected MpUnboundedXaddChunk(long index, R prev, int size, boolean pooled) {
        this.buffer = UnsafeRefArrayAccess.allocateRefArray((int)size);
        this.soPrev(prev);
        this.spIndex(index);
        this.pooled = pooled;
    }

    public final boolean isPooled() {
        return this.pooled;
    }

    public final long lvIndex() {
        return this.index;
    }

    public final void soIndex(long index) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, INDEX_OFFSET, index);
    }

    final void spIndex(long index) {
        UnsafeAccess.UNSAFE.putLong(this, INDEX_OFFSET, index);
    }

    public final R lvNext() {
        return this.next;
    }

    public final void soNext(R value) {
        UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, value);
    }

    public final R lvPrev() {
        return this.prev;
    }

    public final void soPrev(R value) {
        UnsafeAccess.UNSAFE.putObject(this, PREV_OFFSET, value);
    }

    public final void soElement(int index, E e) {
        UnsafeRefArrayAccess.soRefElement((Object[])this.buffer, (long)UnsafeRefArrayAccess.calcRefElementOffset((long)index), e);
    }

    public final E lvElement(int index) {
        return (E)UnsafeRefArrayAccess.lvRefElement((Object[])this.buffer, (long)UnsafeRefArrayAccess.calcRefElementOffset((long)index));
    }

    public final E spinForElement(int index, boolean isNull) {
        Object e;
        Object[] buffer = this.buffer;
        long offset = UnsafeRefArrayAccess.calcRefElementOffset((long)index);
        while (isNull != ((e = UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset)) == null)) {
        }
        return (E)e;
    }
}

