/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues;

import java.util.Arrays;
import org.openjdk.btrace.libs.org.jctools.queues.MpUnboundedXaddChunk;
import org.openjdk.btrace.libs.org.jctools.util.UnsafeLongArrayAccess;

public final class MpmcUnboundedXaddChunk<E>
extends MpUnboundedXaddChunk<MpmcUnboundedXaddChunk<E>, E> {
    private final long[] sequence;

    public MpmcUnboundedXaddChunk(long index, MpmcUnboundedXaddChunk<E> prev, int size, boolean pooled) {
        super(index, prev, size, pooled);
        if (pooled) {
            this.sequence = UnsafeLongArrayAccess.allocateLongArray((int)size);
            Arrays.fill(this.sequence, -1L);
        } else {
            this.sequence = null;
        }
    }

    public void soSequence(int index, long e) {
        assert (this.isPooled());
        UnsafeLongArrayAccess.soLongElement((long[])this.sequence, (long)UnsafeLongArrayAccess.calcLongElementOffset((long)index), (long)e);
    }

    public long lvSequence(int index) {
        assert (this.isPooled());
        return UnsafeLongArrayAccess.lvLongElement((long[])this.sequence, (long)UnsafeLongArrayAccess.calcLongElementOffset((long)index));
    }

    public void spinForSequence(int index, long e) {
        assert (this.isPooled());
        long[] sequence = this.sequence;
        long offset = UnsafeLongArrayAccess.calcLongElementOffset((long)index);
        while (UnsafeLongArrayAccess.lvLongElement((long[])sequence, (long)offset) != e) {
        }
    }
}

