/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues;

import org.openjdk.btrace.libs.org.jctools.queues.MpscArrayQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MpscCompoundQueueL0Pad;
import org.openjdk.btrace.libs.org.jctools.util.Pow2;
import org.openjdk.btrace.libs.org.jctools.util.RangeUtil;

abstract class MpscCompoundQueueColdFields<E>
extends MpscCompoundQueueL0Pad<E> {
    protected final int parallelQueues;
    protected final int parallelQueuesMask;
    protected final MpscArrayQueue<E>[] queues;

    MpscCompoundQueueColdFields(int capacity, int queueParallelism) {
        this.parallelQueues = Pow2.isPowerOfTwo((int)queueParallelism) ? queueParallelism : Pow2.roundToPowerOfTwo((int)queueParallelism) / 2;
        this.parallelQueuesMask = this.parallelQueues - 1;
        this.queues = new MpscArrayQueue[this.parallelQueues];
        int fullCapacity = Pow2.roundToPowerOfTwo((int)capacity);
        RangeUtil.checkGreaterThanOrEqual((int)fullCapacity, (int)this.parallelQueues, (String)"fullCapacity");
        for (int i = 0; i < this.parallelQueues; ++i) {
            this.queues[i] = new MpscArrayQueue(fullCapacity / this.parallelQueues);
        }
    }
}

