/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues;

import org.openjdk.btrace.libs.org.jctools.queues.BaseSpscLinkedArrayQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.util.Pow2;
import org.openjdk.btrace.libs.org.jctools.util.UnsafeRefArrayAccess;

public class SpscUnboundedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscUnboundedArrayQueue(int chunkSize) {
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo((int)chunkSize), 16);
        long mask = chunkCapacity - 1;
        Object[] buffer = UnsafeRefArrayAccess.allocateRefArray((int)(chunkCapacity + 1));
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
    }

    @Override
    final boolean offerColdPath(E[] buffer, long mask, long pIndex, long offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)UnsafeRefArrayAccess.calcCircularRefElementOffset((long)pBufferLimit, (long)mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)UnsafeRefArrayAccess.calcCircularRefElementOffset((long)(pIndex + 1L), (long)mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            Object[] newBuffer = UnsafeRefArrayAccess.allocateRefArray((int)((int)(mask + 2L)));
            this.producerBuffer = newBuffer;
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill((MessagePassingQueue.Supplier)s, (int)this.producerMask);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

