/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.openjdk.btrace.libs.org.jctools.queues.atomic.AtomicQueueUtil;
import org.openjdk.btrace.libs.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import org.openjdk.btrace.libs.org.jctools.util.Pow2;
import org.openjdk.btrace.libs.org.jctools.util.RangeUtil;

public class MpscGrowableAtomicArrayQueue<E>
extends MpscChunkedAtomicArrayQueue<E> {
    public MpscGrowableAtomicArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo((int)(maxCapacity / 8))), maxCapacity);
    }

    public MpscGrowableAtomicArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual((int)AtomicQueueUtil.length(buffer), (long)maxSize, (String)"buffer.length");
        int newSize = 2 * (AtomicQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

