/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues.unpadded;

import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.queues.unpadded.BaseSpscLinkedUnpaddedArrayQueue;
import org.openjdk.btrace.libs.org.jctools.util.Pow2;
import org.openjdk.btrace.libs.org.jctools.util.RangeUtil;
import org.openjdk.btrace.libs.org.jctools.util.UnsafeRefArrayAccess;

public class SpscChunkedUnpaddedArrayQueue<E>
extends BaseSpscLinkedUnpaddedArrayQueue<E> {
    private final int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedUnpaddedArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo((int)(capacity / 8))), capacity);
    }

    public SpscChunkedUnpaddedArrayQueue(int chunkSize, int capacity) {
        RangeUtil.checkGreaterThanOrEqual((int)capacity, (int)16, (String)"capacity");
        RangeUtil.checkGreaterThanOrEqual((int)chunkSize, (int)8, (String)"chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo((int)capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo((int)chunkSize);
        RangeUtil.checkLessThan((int)chunkCapacity, (int)this.maxQueueCapacity, (String)"chunkCapacity");
        long mask = chunkCapacity - 1;
        Object[] buffer = UnsafeRefArrayAccess.allocateRefArray((int)(chunkCapacity + 1));
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
    }

    @Override
    final boolean offerColdPath(E[] buffer, long mask, long pIndex, long offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        long pQueueLimit = this.producerQueueLimit;
        if (pIndex >= pQueueLimit) {
            long cIndex = this.lvConsumerIndex();
            this.producerQueueLimit = pQueueLimit = cIndex + (long)this.maxQueueCapacity;
            if (pIndex >= pQueueLimit) {
                return false;
            }
        }
        if (pBufferLimit - pQueueLimit > 0L) {
            pBufferLimit = pQueueLimit;
        }
        if (pBufferLimit > pIndex + 1L && null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)UnsafeRefArrayAccess.calcCircularRefElementOffset((long)pBufferLimit, (long)mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)UnsafeRefArrayAccess.calcCircularRefElementOffset((long)(pIndex + 1L), (long)mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            Object[] newBuffer = UnsafeRefArrayAccess.allocateRefArray((int)((int)(mask + 2L)));
            this.producerBuffer = newBuffer;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

