/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues.unpadded;

import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.queues.unpadded.SpscUnpaddedArrayQueueL3Pad;
import org.openjdk.btrace.libs.org.jctools.util.UnsafeRefArrayAccess;

public class SpscUnpaddedArrayQueue<E>
extends SpscUnpaddedArrayQueueL3Pad<E> {
    public SpscUnpaddedArrayQueue(int capacity) {
        super(Math.max(capacity, 4));
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        if (producerIndex >= this.producerLimit && !this.offerSlowPath(buffer, mask, producerIndex)) {
            return false;
        }
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)producerIndex, (long)mask);
        UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    private boolean offerSlowPath(E[] buffer, long mask, long producerIndex) {
        int lookAheadStep = this.lookAheadStep;
        if (null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)UnsafeRefArrayAccess.calcCircularRefElementOffset((long)(producerIndex + (long)lookAheadStep), (long)mask))) {
            this.producerLimit = producerIndex + (long)lookAheadStep;
        } else {
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)producerIndex, (long)mask);
            if (null != UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)consumerIndex, (long)this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset);
        if (null == e) {
            return null;
        }
        UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        return (E)UnsafeRefArrayAccess.lvRefElement((Object[])this.buffer, (long)UnsafeRefArrayAccess.calcCircularRefElementOffset((long)this.lpConsumerIndex(), (long)this.mask));
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = consumerIndex + (long)i;
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)index, (long)mask);
            Object e = UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset);
            if (null == e) {
                return i;
            }
            UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = producerIndex + (long)i;
            long lookAheadElementOffset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)(index + (long)lookAheadStep), (long)mask);
            if (null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)lookAheadElementOffset)) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                for (int j = 0; j < lookAheadLimit; ++j) {
                    long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)(index + (long)j), (long)mask);
                    UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                }
                i += lookAheadLimit - 1;
                continue;
            }
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)index, (long)mask);
            if (null != UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset)) {
                return i;
            }
            UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, s.get());
            this.soProducerIndex(index + 1L);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (null == w) {
            throw new IllegalArgumentException("wait is null");
        }
        if (null == exit) {
            throw new IllegalArgumentException("exit condition is null");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int counter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)consumerIndex, (long)mask);
                Object e = UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, null);
                this.soConsumerIndex(++consumerIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        if (null == w) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (null == e) {
            throw new IllegalArgumentException("exit condition is null");
        }
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        int counter = 0;
        while (e.keepRunning()) {
            long lookAheadElementOffset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)(producerIndex + (long)lookAheadStep), (long)mask);
            if (null == UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)lookAheadElementOffset)) {
                for (int j = 0; j < lookAheadStep; ++j) {
                    long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)producerIndex, (long)mask);
                    UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, s.get());
                    this.soProducerIndex(++producerIndex);
                }
                continue;
            }
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset((long)producerIndex, (long)mask);
            if (null != UnsafeRefArrayAccess.lvRefElement((Object[])buffer, (long)offset)) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            UnsafeRefArrayAccess.soRefElement((Object[])buffer, (long)offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

