/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.lang.instrument.Instrumentation;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.jfr.JfrEvent;
import org.openjdk.btrace.runtime.BTraceRuntimeImplBase;
import org.openjdk.btrace.runtime.BTraceRuntimeImplFactory;
import org.openjdk.btrace.runtime.JfrEventFactoryImpl;
import sun.misc.Perf;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class BTraceRuntimeImpl_8
extends BTraceRuntimeImplBase {
    private static final int V_Variable = 3;
    private static final int V_None = 1;
    private static final int V_String = 5;
    private static final int PERF_STRING_LIMIT = 256;
    private final Set<JfrEventFactoryImpl> eventFactories;
    private static Perf perf;
    private final boolean hasJfr;

    public BTraceRuntimeImpl_8() {
        boolean jfr = false;
        try {
            Class.forName("jdk.jfr.Event");
            jfr = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hasJfr = jfr;
        this.eventFactories = this.hasJfr ? new CopyOnWriteArraySet() : null;
    }

    public BTraceRuntimeImpl_8(String className, ArgsMap args, CommandListener cmdListener, Instrumentation inst) {
        super(className, args, cmdListener, inst);
        boolean jfr = false;
        try {
            Class.forName("jdk.jfr.Event");
            jfr = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hasJfr = jfr;
        this.eventFactories = this.hasJfr ? new CopyOnWriteArraySet() : null;
    }

    @Override
    @CallerSensitive
    public Class<?> defineClass(byte[] code, boolean mustBeBootstrap) {
        Unsafe unsafe = BTraceRuntime.initUnsafe();
        if (unsafe != null) {
            Class caller = Reflection.getCallerClass((int)2);
            if (!caller.getName().startsWith("org.openjdk.btrace.")) {
                throw new SecurityException("unsafe defineClass");
            }
            ClassLoader loader = null;
            if (!mustBeBootstrap) {
                loader = new ClassLoader(null){};
            }
            Class cl = unsafe.defineClass(this.getClassName(), code, 0, code.length, loader, null);
            unsafe.ensureClassInitialized(cl);
            return cl;
        }
        return null;
    }

    @Override
    public void newPerfCounter(Object value, String name, String desc) {
        Perf perf = BTraceRuntimeImpl_8.getPerf();
        char tc = desc.charAt(0);
        switch (tc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                long initValue = value != null ? ((Number)value).longValue() : 0L;
                ByteBuffer b = perf.createLong(name, 3, 1, initValue);
                b.order(ByteOrder.nativeOrder());
                counters.put(name, b);
                break;
            }
            case '[': {
                break;
            }
            case 'L': {
                byte[] buf;
                if (!desc.equals("Ljava/lang/String;")) break;
                if (value != null) {
                    buf = BTraceRuntimeImpl_8.getStringBytes((String)value);
                } else {
                    buf = new byte[256];
                    buf[0] = 0;
                }
                ByteBuffer b = perf.createByteArray(name, 3, 5, buf, buf.length);
                counters.put(name, b);
            }
        }
    }

    @Override
    @CallerSensitive
    public ClassLoader getCallerClassLoader(int stackDec) {
        return Reflection.getCallerClass((int)(stackDec + 1)).getClassLoader();
    }

    @Override
    public Class<?> getCallerClass(int stackDec) {
        return Reflection.getCallerClass((int)(stackDec + 1));
    }

    @Override
    public JfrEvent.Factory createEventFactory(JfrEvent.Template template) {
        if (this.hasJfr) {
            JfrEventFactoryImpl factory = new JfrEventFactoryImpl(template);
            this.eventFactories.add(factory);
            return factory;
        }
        return () -> JfrEvent.EMPTY;
    }

    @Override
    protected void cleanupRuntime() {
        if (this.hasJfr) {
            for (JfrEventFactoryImpl factory : this.eventFactories) {
                factory.unregister();
            }
            this.eventFactories.clear();
        }
    }

    @Override
    public int version() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Perf getPerf() {
        Class<BTraceRuntimeImpl_8> clazz = BTraceRuntimeImpl_8.class;
        synchronized (BTraceRuntimeImpl_8.class) {
            if (perf == null) {
                perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return perf;
        }
    }

    public static final class Factory
    extends BTraceRuntimeImplFactory<BTraceRuntimeImpl_8> {
        public Factory() {
            super(new BTraceRuntimeImpl_8());
        }

        @Override
        public BTraceRuntimeImpl_8 getRuntime(String className, ArgsMap args, CommandListener cmdListener, Instrumentation inst) {
            return new BTraceRuntimeImpl_8(className, args, cmdListener, inst);
        }

        @Override
        public boolean isEnabled() {
            try {
                Class.forName("java.lang.Module");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
        }
    }
}

