/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openjdk.btrace.runtime.DotWriterFormatter;

public class DOTWriter {
    public static final String DOTWRITER_PREFIX = "dotwriter.";
    static final String FONTDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10";
    static final String GRAPHDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, rankdir=LR";
    static final String NODEDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, label=\"\\N\", shape=record, style=filled, fillcolor=lightgrey, color=black";
    static final String EDGEDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, arrowhead=open";
    static final String STARTNODESTYLE = "fillcolor=pink";
    static final String INTRAEDGESTYLE = "style=dashed, color=grey";
    static final String INTEREDGESTYLE = "style=dashed, color=darkGrey";
    private final DotWriterFormatter dotWriterFormatter = new DotWriterFormatter();
    final Map<Class<?>, Field[]> fieldCache = new HashMap();
    private int objectLimit = 256;
    private int fieldLimit = 64;
    private int arrayLimit = 32;
    private final Map<Object, Node> visited = new IdentityHashMap<Object, Node>();
    private final Properties graphProperties = new Properties();
    private final Properties nodeProperties = new Properties();
    private final Properties edgeProperties = new Properties();
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Edge> edges = new ArrayList<Edge>();
    private PrintStream dotStream;
    private boolean filtering = false;
    private final Set<Object> includeObjects = new HashSet<Object>();
    private final Set<Object> excludeObjects = new HashSet<Object>();
    private final List<Class> includeClasses = new ArrayList<Class>();
    private Pattern includeClassNames;
    private final List<Class> excludeClasses = new ArrayList<Class>();
    private Pattern excludeClassNames;
    private boolean expandCollections = false;
    private boolean displayStatics = false;
    private boolean displayLinks = true;

    public DOTWriter(String fileName) {
        try {
            this.dotStream = new PrintStream(fileName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.graphProperties.addProperties(GRAPHDEFAULTS);
        this.nodeProperties.addProperties(NODEDEFAULTS);
        this.edgeProperties.addProperties(EDGEDEFAULTS);
    }

    public static void graph(String fileName, Object ... objects) {
        DOTWriter writer = new DOTWriter(fileName);
        String propertyString = STARTNODESTYLE;
        for (Object object : objects) {
            if (object instanceof String) {
                propertyString = (String)object;
                continue;
            }
            writer.addNode(propertyString, object);
        }
        writer.close();
    }

    private static String escapeString(String value) {
        if (DOTWriter.needsEscape(value)) {
            StringBuilder result = new StringBuilder();
            result.append('\"');
            StringCharacterIterator iterator = new StringCharacterIterator(value);
            char ch = iterator.current();
            while (ch != '\uffff') {
                if (ch == '\"' || ch == '\'' || ch == '{' || ch == '}' || ch == '[' || ch == ']') {
                    result.append('\\');
                    result.append(ch);
                } else if (ch < ' ' || ch > '~') {
                    result.append("\\\\u");
                    String hex = "0000" + Integer.toHexString(ch);
                    hex = hex.substring(hex.length() - 4);
                    result.append(hex);
                } else {
                    result.append(ch);
                }
                ch = iterator.next();
            }
            result.append('\"');
            value = result.toString();
        }
        return value;
    }

    private static boolean needsEscape(String value) {
        if (value.length() > 0 && value.charAt(0) == '\"') {
            return false;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(value);
        char ch = iterator.current();
        while (ch != '\uffff') {
            if (!Character.isJavaIdentifierPart(ch) && ch != '-') {
                return true;
            }
            ch = iterator.next();
        }
        return false;
    }

    public void customize(java.util.Properties props) {
        String prop = props.getProperty("dotwriter.objectlimit");
        if (prop != null) {
            this.objectLimit(Integer.parseInt(prop));
        }
        if ((prop = props.getProperty("dotwriter.fieldLimit")) != null) {
            this.fieldLimit(Integer.parseInt(prop));
        }
        if ((prop = props.getProperty("dotwriter.stringLimit")) != null) {
            this.dotWriterFormatter.stringLimit(Integer.parseInt(prop));
        }
        if ((prop = props.getProperty("dotwriter.arrayLimit")) != null) {
            this.arrayLimit(Integer.parseInt(prop));
        }
        if ((prop = props.getProperty("dotwriter.expandCollections")) != null) {
            this.expandCollections(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("dotwriter.diaplayLinks")) != null) {
            this.displayLinks(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("dotwriter.displayStatics")) != null) {
            this.displayStatics(Boolean.parseBoolean(prop));
        }
        if ((prop = props.getProperty("dotwriter.excludeClassNames")) != null) {
            this.excludeClassNames(Pattern.compile(prop));
        }
        if ((prop = props.getProperty("dotwriter.includeClassNames")) != null) {
            this.includeClassNames(Pattern.compile(prop));
        }
    }

    public void addNodes(Object ... objects) {
        String propertyString = null;
        for (Object object : objects) {
            if (object instanceof String) {
                propertyString = (String)object;
                continue;
            }
            this.addNode(propertyString, object);
        }
    }

    public void addNode(String propertyString, Object object) {
        if (object == null) {
            return;
        }
        if (this.isPrimitive(object)) {
            return;
        }
        Node newNode = this.getNode(object);
        for (int index = this.nodes.size(); index < this.nodes.size(); ++index) {
            Node node = this.nodes.get(index);
            object = node.object;
            Class<?> clazz = object.getClass();
            this.addHeader(object, clazz, node);
            if (clazz.isArray()) {
                if (index < this.arrayLimit && this.shouldDetail(object)) {
                    this.addArrayDetail(object, node);
                    continue;
                }
                this.addContinuation(node);
                continue;
            }
            if (index < this.objectLimit && this.shouldDetail(object)) {
                if (!this.expandCollections && object instanceof Collection) {
                    this.addCollectionDetail(object, clazz, node);
                    continue;
                }
                if (!this.expandCollections && object instanceof Map) {
                    this.addMapDetail(object, clazz, node);
                    continue;
                }
                if (this.displayStatics && object instanceof Class) {
                    this.addClassDetail(object, clazz, node);
                    continue;
                }
                this.addObjectDetail(object, clazz, node);
                continue;
            }
            this.addContinuation(node);
        }
        if (propertyString != null) {
            newNode.addProperties(propertyString);
        }
    }

    public void objectLimit(int objectLimit) {
        this.objectLimit = objectLimit;
    }

    public void fieldLimit(int fieldLimit) {
        this.fieldLimit = fieldLimit;
    }

    public void arrayLimit(int arrayLimit) {
        this.arrayLimit = arrayLimit;
    }

    public void stringLimit(int stringLimit) {
        this.dotWriterFormatter.stringLimit(stringLimit);
    }

    public void expandCollections(boolean expandCollections) {
        this.expandCollections = expandCollections;
    }

    public void displayStatics(boolean displayStatics) {
        this.displayStatics = displayStatics;
    }

    public void displayLinks(boolean displayLinks) {
        this.displayLinks = displayLinks;
    }

    public void includeObjects(Object ... objects) {
        this.includeObjects.addAll(Arrays.asList(objects));
        this.filtering = true;
    }

    public void excludeObjects(Object ... objects) {
        this.excludeObjects.addAll(Arrays.asList(objects));
        this.filtering = true;
    }

    public void includeClasses(Class ... clazzes) {
        this.includeClasses.addAll(Arrays.asList(clazzes));
        this.filtering = true;
    }

    public void includeClassNames(Pattern pattern) {
        this.includeClassNames = pattern;
        this.filtering = true;
    }

    public void excludeClasses(Class ... clazzes) {
        this.excludeClasses.addAll(Arrays.asList(clazzes));
        this.filtering = true;
    }

    public void excludeClassNames(Pattern pattern) {
        this.excludeClassNames = pattern;
        this.filtering = true;
    }

    public void addEdge(Object head, Object tail) {
        this.addEdge(head, -1, tail, -1, null);
    }

    public void addEdge(Object head, Object tail, String propertyString) {
        this.addEdge(head, -1, tail, -1, propertyString);
    }

    public void addEdge(Object head, int headFieldId, Object tail, int tailFieldId) {
        this.addEdge(head, headFieldId, tail, tailFieldId, null);
    }

    public void addEdge(Object head, int headFieldId, Object tail, int tailFieldId, String propertyString) {
        this.addEdge(this.getNode(head), headFieldId, this.getNode(tail), tailFieldId, propertyString);
    }

    private void addEdge(Node head, int headFieldId, Node tail, int tailFieldId) {
        this.addEdge(head, headFieldId, tail, tailFieldId, null);
    }

    public void close() {
        if (this.dotStream != null) {
            this.writeGraph();
            this.dotStream.close();
            this.dotStream = null;
        }
    }

    private boolean isPrimitive(Object object) {
        return object.getClass().isPrimitive() || object instanceof Number || object instanceof Boolean || object instanceof String;
    }

    private void writeGraph() {
        this.dotStream.println("digraph g {");
        this.dotStream.print(" graph ");
        this.graphProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        this.dotStream.print(" node ");
        this.nodeProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        this.dotStream.print(" edge ");
        this.edgeProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        for (Node node : this.nodes) {
            this.dotStream.print(" node" + node.id + " ");
            node.writeProperties(this.dotStream);
            this.dotStream.println(";");
        }
        for (Edge edge : this.edges) {
            this.dotStream.print(" node" + edge.head.id + (edge.headFieldId < 0 ? ":f" : ":f" + edge.headFieldId));
            this.dotStream.print(" -> ");
            this.dotStream.print(" node" + edge.tail.id + (edge.tailFieldId < 0 ? ":f" : ":f" + edge.tailFieldId));
            this.dotStream.print(" ");
            edge.writeProperties(this.dotStream);
            this.dotStream.println(";");
        }
        this.dotStream.println("}");
    }

    private Node getNode(Object object) {
        if (object == null) {
            return null;
        }
        Node node = null;
        try {
            node = this.visited.get(object);
        }
        catch (Throwable ex) {
            return null;
        }
        if (node == null) {
            node = new Node(this.nodes.size(), object);
            this.nodes.add(node);
            this.visited.put(object, node);
        }
        return node;
    }

    private boolean shouldDetail(Object object) {
        if (object == this) {
            return false;
        }
        if (!this.filtering) {
            return true;
        }
        if (!this.includeObjects.isEmpty()) {
            return this.includeObjects.contains(object);
        }
        if (!this.includeClasses.isEmpty()) {
            for (Class clazz : this.includeClasses) {
                if (!clazz.isInstance(object)) continue;
                return true;
            }
            return false;
        }
        if (this.includeClassNames != null) {
            return this.includeClassNames.matcher(object.getClass().getName()).matches();
        }
        if (!this.excludeObjects.isEmpty() && this.excludeObjects.contains(object)) {
            return false;
        }
        if (!this.excludeClasses.isEmpty()) {
            for (Class clazz : this.excludeClasses) {
                if (!clazz.isInstance(object)) continue;
                return false;
            }
        }
        if (this.excludeClassNames != null) {
            return !this.excludeClassNames.matcher(object.getClass().getName()).matches();
        }
        return true;
    }

    private void addEdge(Node head, int headFieldId, Node tail, int tailFieldId, String propertyString) {
        if (head == null || tail == null) {
            return;
        }
        if (headFieldId > this.getLimit(head) && head.id >= this.objectLimit) {
            headFieldId = -1;
        }
        if (tailFieldId > this.getLimit(tail) && tail.id >= this.objectLimit) {
            tailFieldId = -1;
        }
        Edge edge = new Edge(this.edges.size(), head, headFieldId, tail, tailFieldId);
        if (propertyString != null) {
            edge.addProperties(propertyString);
        }
        this.edges.add(edge);
    }

    private int getLimit(Node node) {
        return node.object.getClass().isArray() ? this.arrayLimit : this.fieldLimit;
    }

    private String getClassName(Class clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        if (name == null) {
            name = clazz.getSimpleName();
        }
        return name;
    }

    private void addHeader(Object object, Class clazz, Node node) {
        if (this.displayStatics && object instanceof Class) {
            clazz = (Class)object;
        }
        String className = this.getClassName(clazz);
        if (object instanceof Class) {
            className = className + "(Class)";
        }
        node.addProperty("label", "<f> " + className);
    }

    private void addContinuation(Node node) {
        node.extendProperty("label", " | ...");
    }

    private Object getValue(Field field, Object object) {
        Object value = null;
        try {
            value = field.get(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    private Field[] getFields(Class clazz) {
        if (clazz == null) {
            return new Field[0];
        }
        if (this.displayStatics && clazz == Class.class) {
            return new Field[0];
        }
        Field[] fields = this.fieldCache.get(clazz);
        if (fields != null) {
            return fields;
        }
        Field[] superFields = this.getFields(clazz.getSuperclass());
        Field[] classFields = clazz.getDeclaredFields();
        fields = new Field[superFields.length + classFields.length];
        System.arraycopy(superFields, 0, fields, 0, superFields.length);
        System.arraycopy(classFields, 0, fields, superFields.length, classFields.length);
        this.fieldCache.put(clazz, fields);
        return fields;
    }

    private void addObjectDetail(Object object, Class clazz, Node node) {
        Field[] fields = this.getFields(clazz);
        if (this.displayStatics && fields.length != 0) {
            this.addEdge(node, -1, this.getNode(clazz), -1);
        }
        for (int index = 0; index < fields.length && index < this.fieldLimit; ++index) {
            Field field = fields[index];
            if ((field.getModifiers() & 8) != 0) continue;
            field.setAccessible(true);
            String name = field.getName();
            Object value = this.getValue(field, object);
            Format format = new Format(value);
            this.addNodeField(node, name, index, format.string);
            if (!this.displayLinks || format.isSimple) continue;
            this.addEdge(node, index, this.getNode(value), -1);
        }
        if (fields.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private void addClassDetail(Object object, Class clazz, Node node) {
        Field[] fields = this.getFields((Class)object);
        for (int index = 0; index < fields.length && index < this.fieldLimit; ++index) {
            Field field = fields[index];
            if ((field.getModifiers() & 8) == 0) continue;
            field.setAccessible(true);
            String name = field.getName();
            Object value = this.getValue(field, object);
            Format format = new Format(value);
            this.addNodeField(node, name, index, format.string);
            if (!this.displayLinks || format.isSimple) continue;
            this.addEdge(node, index, this.getNode(value), -1);
        }
        if (fields.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private void addCollectionDetail(Object object, Class clazz, Node node) {
        Object[] array = ((Collection)object).toArray();
        this.addArrayDetail(array, node);
    }

    private void addMapDetail(Object object, Class clazz, Node node) {
        Object[] array = ((Map)object).entrySet().toArray();
        this.addArrayDetail(array, node);
    }

    private void addArrayDetail(Object object, Node node) {
        int length = Array.getLength(object);
        if (object instanceof char[] || object instanceof byte[] && this.allASCII((byte[])object)) {
            Format format = new Format(object);
            String string = " | " + format.string;
            node.extendProperty("label", string);
            length = 0;
        } else {
            for (int index = 0; index < length && index < this.arrayLimit; ++index) {
                Object value = Array.get(object, index);
                Format format = new Format(value);
                this.addNodeField(node, null, index, format.string);
                if (!this.displayLinks || format.isSimple) continue;
                this.addEdge(node, index, this.getNode(value), -1);
            }
        }
        if (length >= this.arrayLimit) {
            this.addContinuation(node);
        }
    }

    private void addNodeField(Node node, String fieldName, int fieldId, String valueString) {
        String labelString = " | ";
        labelString = labelString + "<f" + fieldId + "> ";
        if (fieldName != null) {
            labelString = labelString + fieldName + ": ";
        }
        labelString = labelString + valueString;
        node.extendProperty("label", labelString);
    }

    private boolean allASCII(byte[] array) {
        for (byte b : array) {
            char ch = (char)b;
            if (ch >= ' ' && '~' >= ch) continue;
            return false;
        }
        return true;
    }

    class Format {
        String string = "";
        boolean isSimple = true;

        Format(Object value) {
            if (value == null) {
                this.string = this.string + value;
                this.isSimple = false;
            } else if (value instanceof String) {
                this.string = DOTWriter.this.dotWriterFormatter.formatString((String)value, "\"");
            } else if (value instanceof char[]) {
                this.string = DOTWriter.this.dotWriterFormatter.formatString(new String((char[])value), "'");
            } else if (value instanceof byte[] && DOTWriter.this.allASCII((byte[])value)) {
                this.string = DOTWriter.this.dotWriterFormatter.formatString(new String((byte[])value, StandardCharsets.UTF_8), "'");
            } else if (value instanceof Character) {
                Character character = (Character)value;
                this.string = "'" + character + "'";
            } else if (!DOTWriter.this.expandCollections && value instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)value;
                Format keyFormat = new Format(entry.getKey());
                Format valueFormat = new Format(entry.getValue());
                if (!keyFormat.isSimple) {
                    this.isSimple = false;
                } else {
                    this.string = keyFormat.string + "-\\>";
                    if (valueFormat.isSimple) {
                        this.string = this.string + valueFormat.string;
                    } else {
                        this.isSimple = false;
                    }
                }
            } else if (DOTWriter.this.isPrimitive(value)) {
                this.string = this.string + value;
            } else {
                this.isSimple = false;
            }
        }
    }

    static class Edge
    extends Element {
        final Node head;
        final int headFieldId;
        final Node tail;
        final int tailFieldId;

        Edge(int id, Node head, int headFieldId, Node tail, int tailFieldId) {
            super(id);
            this.head = head;
            this.headFieldId = headFieldId;
            this.tail = tail;
            this.tailFieldId = tailFieldId;
        }
    }

    static class Node
    extends Element {
        final Object object;

        Node(int id, Object object) {
            super(id);
            this.object = object;
        }
    }

    static class Element
    extends Properties {
        final int id;

        Element(int id) {
            this.id = id;
        }
    }

    static class Properties {
        private final Map<String, String> properties = new HashMap<String, String>();

        Properties() {
        }

        void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        void addProperties(String propertyString) {
            String[] kvs;
            for (String kv : kvs = propertyString.split("\\s*,\\s*")) {
                String[] pair = kv.split("\\s*=\\s*");
                if (pair.length == 1) {
                    this.properties.put(pair[0], "true");
                    continue;
                }
                this.properties.put(pair[0], pair[1]);
            }
        }

        void extendProperty(String key, String extension) {
            String value = this.getProperty(key);
            if (value == null) {
                value = "";
            }
            value = value + extension;
            this.addProperty(key, value);
        }

        String getProperty(String key) {
            return this.properties.get(key);
        }

        void writeProperties(PrintStream dotStream) {
            if (!this.properties.isEmpty()) {
                dotStream.print("[");
                String comma = "";
                for (String key : this.properties.keySet()) {
                    String value = this.properties.get(key);
                    if (value.equals("true")) {
                        dotStream.print(comma + key);
                    } else {
                        dotStream.print(comma + key + "=" + DOTWriter.escapeString(value));
                    }
                    comma = ", ";
                }
                dotStream.print("]");
            }
        }
    }
}

