/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.IdentityHashMap;
import java.util.Map;

final class XMLSerializer {
    private static final String ID = "id";
    private static final String IDREF = "idref";
    private static final String CLASS = "class";

    private XMLSerializer() {
    }

    public static void write(Object obj, Writer out) throws IOException {
        if (obj == null || out == null) {
            throw new NullPointerException();
        }
        Serializer s = new Serializer(out);
        s.write(obj);
        out.flush();
    }

    public static String toXML(Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException();
        }
        StringWriter sw = new StringWriter();
        XMLSerializer.write(obj, sw);
        return sw.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            System.out.println(XMLSerializer.toXML(args));
        } else {
            System.out.println(XMLSerializer.toXML(XMLSerializer.class));
        }
    }

    private static class Serializer {
        private static final CharsetEncoder encoder = Charset.forName("8859_1").newEncoder();
        private final PrintWriter out;
        private final Map<Object, String> objToId;
        private long nextId;

        Serializer(Writer writer) {
            this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            this.objToId = new IdentityHashMap<Object, String>();
            this.writeln("<?xml version='1.0' encoding='ISO-8859-1'?>");
        }

        private static Field[] getAllFields(Class clazz) {
            return AccessController.doPrivileged(() -> {
                try {
                    Field[] fields;
                    for (Field f : fields = clazz.getDeclaredFields()) {
                        f.setAccessible(true);
                    }
                    return fields;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
            });
        }

        private static String encodeTagName(String str) {
            return str.replace("$", "d-");
        }

        private static String quote(int code) {
            switch (code) {
                case 38: {
                    return "&amp;";
                }
                case 60: {
                    return "&lt;";
                }
                case 62: {
                    return "&gt;";
                }
                case 34: {
                    return "&quot;";
                }
                case 39: {
                    return "&apos;";
                }
            }
            return null;
        }

        private static boolean isValidCharCode(int code) {
            return 32 <= code && code <= 55295 || 10 == code || 9 == code || 13 == code || 57344 <= code && code <= 65533 || 65536 <= code && code <= 0x10FFFF;
        }

        private static String encodeCode(int code) {
            return "<char cp=\"#" + Integer.toString(code, 16) + "\"/>";
        }

        private static String encodeText(char ch) {
            return Serializer.encodeText(new char[]{ch});
        }

        private static String encodeText(char[] array) {
            return Serializer.encodeText(new String(array));
        }

        private static String encodeText(String string) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            int len = string.length();
            while (index < len) {
                int point = string.codePointAt(index);
                int count = Character.charCount(point);
                if (Serializer.isValidCharCode(point)) {
                    if (encoder.canEncode(string.substring(index, index + count))) {
                        String value = Serializer.quote(point);
                        if (value != null) {
                            sb.append(value);
                        } else {
                            sb.appendCodePoint(point);
                        }
                    } else {
                        sb.append("&#x");
                        sb.append(Integer.toString(point, 16));
                        sb.append(';');
                    }
                    index += count;
                    continue;
                }
                sb.append(Serializer.encodeCode(string.charAt(index)));
                ++index;
            }
            return sb.toString();
        }

        void write(Object obj) {
            if (obj instanceof Class) {
                this.write(XMLSerializer.CLASS, obj);
            } else {
                this.write("object", obj);
            }
        }

        void write(String name, Object obj) {
            name = Serializer.encodeTagName(name);
            if (obj == null) {
                this.out.print('<');
                this.out.print(name);
                this.out.print(">null</");
                this.out.print(name);
                this.writeln('>');
                return;
            }
            if (this.hasSeenAlready(name, obj)) {
                return;
            }
            Class<?> clazz = obj.getClass();
            if (clazz.isArray()) {
                this.writeArray(name, obj);
            } else {
                this.writeObject(name, obj);
            }
        }

        private String nextObjectId(Object obj) {
            return Long.toString(this.nextId++);
        }

        private void writeln(String str) {
            this.out.print(str);
            this.out.print("\r\n");
        }

        private void writeln(char ch) {
            this.out.print(ch);
            this.out.print("\r\n");
        }

        private void writeln() {
            this.out.print("\r\n");
        }

        private void writeAttribute(String name, String value) {
            this.out.print(name);
            this.out.print("=\"");
            this.out.print(value);
            this.out.print("\"");
        }

        private void writeIdProperty(Object obj) {
            String id = this.nextObjectId(obj);
            this.writeAttribute(XMLSerializer.ID, id);
            this.objToId.put(obj, id);
        }

        private boolean hasSeenAlready(String name, Object obj) {
            String id = this.objToId.get(obj);
            if (id != null) {
                this.out.print('<');
                this.out.print(name);
                this.out.print(' ');
                this.writeAttribute(XMLSerializer.IDREF, id);
                this.writeln("/>");
                return true;
            }
            return false;
        }

        private void arrayStart(String name, Object obj) {
            this.objectStart(name, obj);
        }

        private void arrayEnd(String name, Object obj) {
            this.objectEnd(name, obj);
        }

        private void writeArray(String name, Object array) {
            this.arrayStart(name, array);
            int len = Array.getLength(array);
            if (len == 0) {
                this.arrayEnd(name, array);
                return;
            }
            Class<?> clazz = array.getClass().getComponentType();
            this.writeln("<elements>");
            if (clazz.isPrimitive()) {
                if (clazz == Character.TYPE) {
                    this.out.print(Serializer.encodeText((char[])array));
                } else {
                    for (int index = 0; index < len; ++index) {
                        this.out.print(Array.get(array, index));
                        if (index == len - 1) continue;
                        this.out.print(", ");
                    }
                }
                this.writeln();
            } else {
                for (int index = 0; index < len; ++index) {
                    this.write("li", Array.get(array, index));
                }
            }
            this.writeln("</elements>");
            this.arrayEnd(name, array);
        }

        private void objectStart(String name, Object obj) {
            this.out.print('<');
            this.out.print(name);
            this.out.print(' ');
            this.writeIdProperty(obj);
            this.writeln('>');
            this.write(XMLSerializer.CLASS, obj.getClass());
        }

        private void objectEnd(String name, Object obj) {
            this.out.print("</");
            this.out.print(name);
            this.writeln('>');
        }

        private void writeObject(String name, Object obj) {
            this.objectStart(name, obj);
            if (obj instanceof Class) {
                Class<?>[] interfaces;
                Class sc;
                Object[] signers;
                ProtectionDomain protDomain;
                Class clazz = (Class)obj;
                this.writeStaticFields(clazz);
                this.write("name", clazz.getName());
                ClassLoader loader = clazz.getClassLoader();
                if (loader != null) {
                    this.write("loader", loader);
                }
                if ((protDomain = clazz.getProtectionDomain()) != null) {
                    this.write("protectionDomain", protDomain);
                }
                if ((signers = clazz.getSigners()) != null && signers.length > 0) {
                    this.write("signers", signers);
                }
                if ((sc = clazz.getSuperclass()) != null) {
                    this.writeln("<extends>");
                    this.write(XMLSerializer.CLASS, sc);
                    this.writeln("</extends>");
                }
                if ((interfaces = clazz.getInterfaces()) != null && interfaces.length > 0) {
                    this.writeln("<implements>");
                    for (Class<?> cl : interfaces) {
                        this.write(XMLSerializer.CLASS, cl);
                    }
                    this.writeln("</implements>");
                }
            } else {
                for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    this.writeFields(obj, clazz);
                }
            }
            this.objectEnd(name, obj);
        }

        private void writeStaticFields(Class clazz) {
            Field[] fields = Serializer.getAllFields(clazz);
            if (fields.length == 0) {
                return;
            }
            this.writeln("<fields>");
            for (Field f : fields) {
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                this.writeField(f, null);
            }
            this.writeln("</fields>");
        }

        private void writeFields(Object obj, Class clazz) {
            Field[] fields;
            for (Field f : fields = Serializer.getAllFields(clazz)) {
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                this.writeField(f, obj);
            }
        }

        private void writeField(Field f, Object obj) {
            Class<?> type = f.getType();
            try {
                if (type.isPrimitive()) {
                    String name = Serializer.encodeTagName(f.getName());
                    String value = type == Character.TYPE ? Serializer.encodeText(f.getChar(obj)) : f.get(obj).toString();
                    this.out.print("<");
                    this.out.print(name);
                    this.out.print(">");
                    this.out.print(value);
                    this.out.print("</");
                    this.out.print(name);
                    this.writeln('>');
                } else {
                    this.write(f.getName(), f.get(obj));
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exp) {
                throw new RuntimeException(exp);
            }
        }
    }
}

