/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime.profiling;

import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.openjdk.btrace.core.Profiler;

class MethodInvocationRecorder {
    private final int defaultBufferSize;
    private final Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private final AtomicInteger writerStatus = new AtomicInteger(0);
    private final Deque<DelayedRecord> delayedRecords = new LinkedList<DelayedRecord>();
    private int stackSize = 200;
    private int stackPtr = -1;
    private int stackBndr = 150;
    private Profiler.Record[] stackArr = new Profiler.Record[this.stackSize];
    private int measuredSize = 0;
    private int measuredPtr = 0;
    private Profiler.Record[] measured = new Profiler.Record[0];
    private long carryOver = 0L;
    private volatile int lastIndex = 0;

    public MethodInvocationRecorder(int expectedBlockCnt) {
        this.measuredSize = this.defaultBufferSize = expectedBlockCnt << 8;
        this.measured = new Profiler.Record[this.measuredSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordEntry(String blockName) {
        while (true) {
            this.processDelayedRecords();
            if (this.writerStatus.compareAndSet(0, 1)) {
                try {
                    this.processEntry(blockName);
                    return;
                }
                finally {
                    this.writerStatus.compareAndSet(1, 0);
                }
            }
            while (this.writerStatus.get() == 3) {
                LockSupport.parkNanos(this, 600L);
            }
            if (this.writerStatus.compareAndSet(1, 3)) {
                try {
                    this.delayedRecords.add(new DelayedRecord(blockName, -1L));
                    return;
                }
                finally {
                    this.writerStatus.compareAndSet(3, 1);
                }
            }
            if (this.writerStatus.compareAndSet(2, 3)) {
                try {
                    this.delayedRecords.add(new DelayedRecord(blockName, -1L));
                    return;
                }
                finally {
                    this.writerStatus.compareAndSet(3, 2);
                }
            }
            LockSupport.parkNanos(this, 600L);
        }
    }

    private void processEntry(String blockName) {
        Profiler.Record r = new Profiler.Record(blockName);
        this.addMeasured(r);
        this.push(r);
        this.carryOver = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordExit(String blockName, long duration) {
        while (true) {
            this.processDelayedRecords();
            if (this.writerStatus.compareAndSet(0, 1)) {
                try {
                    this.processExit(blockName, duration);
                    return;
                }
                finally {
                    this.writerStatus.compareAndSet(1, 0);
                }
            }
            while (this.writerStatus.get() == 3) {
                LockSupport.parkNanos(this, 600L);
            }
            if (this.writerStatus.compareAndSet(1, 3)) {
                try {
                    this.delayedRecords.add(new DelayedRecord(blockName, duration));
                    return;
                }
                finally {
                    this.writerStatus.compareAndSet(3, 1);
                }
            }
            if (this.writerStatus.compareAndSet(2, 3)) {
                try {
                    this.delayedRecords.add(new DelayedRecord(blockName, duration));
                    return;
                }
                finally {
                    this.writerStatus.compareAndSet(3, 2);
                }
            }
            LockSupport.parkNanos(this, 600L);
        }
    }

    private void processExit(String blockName, long duration) {
        Profiler.Record r = this.pop();
        if (r == null) {
            r = new Profiler.Record(blockName);
            this.addMeasured(r);
        }
        r.wallTime = duration;
        r.selfTime += duration - this.carryOver;
        for (int i = 0; i < this.stackPtr; ++i) {
            if (!this.stackArr[i].blockName.equals(blockName)) continue;
            r.wallTime = 0L;
            break;
        }
        r.selfTimeMin = r.selfTimeMax = r.selfTime;
        r.wallTimeMin = r.wallTimeMax = r.wallTime;
        Profiler.Record parent = this.peek();
        if (parent != null) {
            parent.selfTime -= duration;
        } else {
            this.carryOver = duration;
        }
    }

    private void processDelayedRecords() {
        DelayedRecord dr = null;
        while (!this.writerStatus.compareAndSet(0, 3)) {
            LockSupport.parkNanos(this, 600L);
        }
        try {
            while ((dr = this.delayedRecords.poll()) != null) {
                if (dr.duration == -1L) {
                    this.processEntry(dr.blockName);
                    continue;
                }
                this.processExit(dr.blockName, dr.duration);
            }
        }
        finally {
            this.writerStatus.compareAndSet(3, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Profiler.Record[] getRecords(boolean reset) {
        Profiler.Record[] recs = null;
        try {
            this.processDelayedRecords();
            while (!this.writerStatus.compareAndSet(0, 2)) {
                LockSupport.parkNanos(this, 600L);
            }
            this.compactMeasured();
            recs = new Profiler.Record[this.lastIndex];
            for (int i = 0; i < recs.length; ++i) {
                Profiler.Record r = this.measured[i];
                if (r != null) {
                    recs[i] = r.duplicate();
                    continue;
                }
                System.err.println("Unexpected NULL record at position " + i + "; ignoring");
            }
            Profiler.Record[] recordArray = recs;
            return recordArray;
        }
        finally {
            while (!this.writerStatus.compareAndSet(2, 0)) {
                LockSupport.parkNanos(this, 600L);
            }
        }
    }

    private void push(Profiler.Record r) {
        if (this.stackPtr > this.stackBndr) {
            this.stackSize = this.stackSize * 3 >> 1;
            this.stackBndr = this.stackBndr * 3 >> 1;
            Profiler.Record[] newStack = new Profiler.Record[this.stackSize];
            System.arraycopy(this.stackArr, 0, newStack, 0, this.stackPtr + 1);
            this.stackArr = newStack;
        }
        this.stackArr[++this.stackPtr] = r;
        r.onStack = true;
    }

    private Profiler.Record pop() {
        Profiler.Record r;
        Profiler.Record record = r = this.stackPtr > -1 ? this.stackArr[this.stackPtr--] : null;
        if (r != null) {
            r.onStack = false;
        }
        return r;
    }

    private Profiler.Record peek() {
        return this.stackPtr > -1 ? this.stackArr[this.stackPtr] : null;
    }

    private void addMeasured(Profiler.Record r) {
        if (this.measuredPtr == this.measuredSize) {
            this.compactMeasured();
        }
        this.measured[this.measuredPtr++] = r;
    }

    void reset() {
        Profiler.Record[] newMeasured = new Profiler.Record[this.defaultBufferSize + this.stackPtr + 1];
        try {
            while (!this.writerStatus.compareAndSet(0, 4)) {
                LockSupport.parkNanos(this, 600L);
            }
            if (this.stackPtr > -1) {
                System.arraycopy(this.stackArr, 0, newMeasured, 0, this.stackPtr + 1);
            }
            Arrays.fill(this.stackArr, null);
            this.indexMap.clear();
            this.measuredPtr = this.stackPtr + 1;
            this.measured = newMeasured;
            this.measuredSize = this.measured.length;
            this.lastIndex = this.measuredPtr;
            this.carryOver = 0L;
        }
        finally {
            this.writerStatus.compareAndSet(4, 0);
        }
    }

    private void compactMeasured() {
        int lastMeasurePtr = this.lastIndex;
        if (this.lastIndex >= this.measuredPtr) {
            return;
        }
        for (int i = this.lastIndex; i < this.measuredPtr; ++i) {
            Profiler.Record m = this.measured[i];
            if (m.onStack) continue;
            Integer newIndex = this.indexMap.get(m.blockName);
            if (newIndex == null) {
                newIndex = lastMeasurePtr++;
                this.indexMap.put(m.blockName, newIndex);
                this.measured[newIndex.intValue()] = m;
                continue;
            }
            Profiler.Record mr = this.measured[newIndex];
            mr.selfTime += m.selfTime;
            mr.wallTime += m.wallTime;
            ++mr.invocations;
            mr.selfTimeMax = Math.max(m.selfTime, mr.selfTimeMax);
            mr.selfTimeMin = Math.min(m.selfTime, mr.selfTimeMin);
            mr.wallTimeMax = Math.max(m.wallTime, mr.wallTimeMax);
            mr.wallTimeMin = Math.min(m.wallTime, mr.wallTimeMin);
            m.referring = mr;
        }
        for (int j = 0; j < this.stackPtr; ++j) {
            Profiler.Record mr = this.stackArr[j].referring;
            if (mr == null) continue;
            this.stackArr[j] = mr;
        }
        if (lastMeasurePtr + this.stackPtr + 1 == this.measuredSize) {
            int newMeasuredSize = (this.measuredSize * 5 >> 2) + (this.stackPtr + 1);
            if (newMeasuredSize == this.measuredSize) {
                newMeasuredSize = (this.measuredSize << 2) + (this.stackPtr + 1);
            }
            Profiler.Record[] newMeasured = new Profiler.Record[newMeasuredSize];
            System.arraycopy(this.measured, 0, newMeasured, 0, lastMeasurePtr);
            this.measured = newMeasured;
            this.measuredSize = newMeasuredSize;
        }
        System.arraycopy(this.stackArr, 0, this.measured, lastMeasurePtr, this.stackPtr + 1);
        this.measuredPtr = lastMeasurePtr + this.stackPtr + 1;
        this.lastIndex = lastMeasurePtr;
    }

    private static class DelayedRecord {
        private final String blockName;
        private final long duration;

        public DelayedRecord(String blockName, long duration) {
            this.blockName = blockName;
            this.duration = duration;
        }
    }
}

