/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.statsd;

import java.util.Formatter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.openjdk.btrace.statsd.Statsd;

class QManager {
    final BlockingQueue<String> q = new ArrayBlockingQueue<String>(120000);

    QManager() {
    }

    BlockingQueue<String> getQ() {
        return this.q;
    }

    private void appendSampleRate(double sampleRate, StringBuilder sb, Formatter fmt) {
        if (sampleRate > 0.0) {
            sb.append("|@");
            fmt.format("%.3f", sampleRate);
        }
    }

    void submit(String name, String value, String type, String tags) {
        StringBuilder sb = new StringBuilder(name);
        sb.append(':').append(value).append('|').append(type);
        this.appendTags(tags, sb);
        this.q.offer(sb.toString());
    }

    public void event(String title, String text, long timestamp, String host, String group, String sourceType, Statsd.Priority priority, Statsd.AlertType alertType, String tags) {
        StringBuilder sb = new StringBuilder("_e{");
        sb.append(title.length()).append(',').append(text.length()).append('}');
        sb.append(':').append(title).append('|').append(text);
        if (timestamp >= 0L) {
            sb.append("|d:").append(timestamp == 0L ? System.currentTimeMillis() : timestamp);
        }
        if (host != null) {
            sb.append("|h:").append(host);
        }
        if (group != null) {
            sb.append("|k:").append(group);
        }
        if (sourceType != null) {
            sb.append("|s:").append(sourceType);
        }
        if (priority != null) {
            sb.append("|p:").append((Object)priority);
        }
        if (alertType != null) {
            sb.append("|t:").append((Object)alertType);
        }
        this.appendTags(tags, sb);
        this.q.offer(sb.toString());
    }

    void delta(String name, long value, double sampleRate, String tags) {
        StringBuilder sb = new StringBuilder(name);
        Formatter fmt = new Formatter(sb);
        sb.append(':');
        if (value > 0L) {
            sb.append('+');
        } else if (value < 0L) {
            sb.append('-');
        }
        sb.append(value).append('|').append('g');
        this.appendSampleRate(sampleRate, sb, fmt);
        this.appendTags(tags, sb);
        this.q.offer(sb.toString());
    }

    private void appendTags(String tags, StringBuilder sb) {
        if (tags != null && !tags.isEmpty()) {
            sb.append("|#").append(tags);
        }
    }

    void submit(String name, long value, double sampleRate, String type, String tags) {
        StringBuilder sb = new StringBuilder(name);
        Formatter fmt = new Formatter(sb);
        sb.append(':').append(value).append('|').append(type);
        this.appendSampleRate(sampleRate, sb, fmt);
        this.appendTags(tags, sb);
        this.q.offer(sb.toString());
    }

    void decrement(String name) {
        this.delta(name, -1L, 0.0, null);
    }
}

