/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.statsd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.services.spi.SimpleService;
import org.openjdk.btrace.statsd.QManager;

public final class Statsd
extends SimpleService {
    private static final Charset CHARSET = StandardCharsets.US_ASCII;
    private final QManager qManager = new QManager();
    private final ExecutorService e = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "jStatsD Client Submitter");
        t.setDaemon(true);
        return t;
    });

    private Statsd() {
        this.e.submit(() -> {
            DatagramSocket ds = null;
            boolean entered = BTraceRuntime.enter();
            try {
                try {
                    ds = new DatagramSocket();
                    DatagramPacket dp = new DatagramPacket(new byte[0], 0);
                    try {
                        dp.setAddress(InetAddress.getByName(SharedSettings.GLOBAL.getStatsdHost()));
                    }
                    catch (UnknownHostException e) {
                        System.err.println("[statsd] invalid host defined: " + SharedSettings.GLOBAL.getStatsdHost());
                        dp.setAddress(InetAddress.getLoopbackAddress());
                    }
                    catch (SecurityException e) {
                        dp.setAddress(InetAddress.getLoopbackAddress());
                    }
                    dp.setPort(SharedSettings.GLOBAL.getStatsdPort());
                    while (true) {
                        ArrayList<String> msgs = new ArrayList<String>();
                        msgs.add(this.qManager.getQ().take());
                        this.qManager.getQ().drainTo(msgs);
                        StringBuilder sb = new StringBuilder();
                        for (String m : msgs) {
                            if (sb.length() + m.length() < 511) {
                                sb.append(m).append('\n');
                                continue;
                            }
                            dp.setData(sb.toString().getBytes(CHARSET));
                            ds.send(dp);
                            sb.setLength(0);
                        }
                        if (sb.length() <= 0) continue;
                        dp.setData(sb.toString().getBytes(CHARSET));
                        ds.send(dp);
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    if (entered) {
                        BTraceRuntime.leave();
                    }
                }
            }
            catch (Throwable throwable) {
                if (entered) {
                    BTraceRuntime.leave();
                }
                throw throwable;
            }
        });
    }

    public static Statsd getInstance() {
        return Singleton.INSTANCE;
    }

    public void increment(String name) {
        this.qManager.delta(name, 1L, 0.0, null);
    }

    public void increment(String name, String tags) {
        this.qManager.delta(name, 1L, 0.0, tags);
    }

    public void increment(String name, double sampleRate) {
        this.qManager.delta(name, 1L, sampleRate, null);
    }

    public void increment(String name, double sampleRate, String tags) {
        this.qManager.delta(name, 1L, sampleRate, tags);
    }

    public void decrement(String name) {
        this.qManager.decrement(name);
    }

    public void decrement(String name, String tags) {
        this.qManager.delta(name, -1L, 0.0, tags);
    }

    public void decrement(String name, double sampleRate) {
        this.qManager.delta(name, -1L, sampleRate, null);
    }

    public void decrement(String name, double sampleRate, String tags) {
        this.qManager.delta(name, -1L, sampleRate, tags);
    }

    public void count(String name, long count) {
        this.count(name, count, null);
    }

    public void count(String name, long count, String tags) {
        this.count(name, count, 0.0, tags);
    }

    public void count(String name, long count, double sampleRate) {
        this.count(name, count, sampleRate, null);
    }

    public void count(String name, long count, double sampleRate, String tags) {
        this.qManager.submit(name, count, sampleRate, "c", tags);
    }

    public void gauge(String name, long value) {
        this.gauge(name, value, null);
    }

    public void gauge(String name, long value, String tags) {
        this.qManager.submit(name, value, 0.0, "g", tags);
    }

    public void time(String name, long value) {
        this.time(name, value, null);
    }

    public void time(String name, long value, double sampleRate) {
        this.time(name, value, sampleRate, null);
    }

    public void time(String name, long value, String tags) {
        this.time(name, value, 0.0, tags);
    }

    public void time(String name, long value, double sampleRate, String tags) {
        this.qManager.submit(name, value, sampleRate, "ms", tags);
    }

    public void histo(String name, long value) {
        this.histo(name, value, null);
    }

    public void histo(String name, long value, double sampleRate) {
        this.histo(name, value, sampleRate, null);
    }

    public void histo(String name, long value, String tags) {
        this.histo(name, value, 0.0, tags);
    }

    public void histo(String name, long value, double sampleRate, String tags) {
        this.qManager.submit(name, value, sampleRate, "h", tags);
    }

    public void unique(String name, String id, String tags) {
        this.qManager.submit(name, id, "s", tags);
    }

    public void unique(String name, String id) {
        this.unique(name, id, null);
    }

    public void event(String title, String text) {
        this.qManager.event(title, text, 0L, null, null, null, null, null, null);
    }

    public void event(String title, String text, String tags) {
        this.qManager.event(title, text, 0L, null, null, null, null, null, tags);
    }

    public void event(String title, String text, long timestamp, String host, String group, String sourceType, Priority priority, AlertType alertType, String tags) {
        this.qManager.event(title, text, timestamp, host, group, sourceType, priority, alertType, tags);
    }

    private static final class Singleton {
        private static final Statsd INSTANCE = new Statsd();

        private Singleton() {
        }
    }

    public static enum AlertType {
        INFO,
        WARNING,
        ERROR,
        SUCCESS;

    }

    public static enum Priority {
        NORMAL,
        LOW;

    }
}

