/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.bc;

import io.buildlogic.truststore.maven.plugin.mojo.CustomScryptConfig;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.bouncycastle.crypto.util.PBKDFConfig;
import org.bouncycastle.crypto.util.ScryptConfig;
import org.bouncycastle.jcajce.BCFKSLoadStoreParameter;

public class BouncyCastleKeyStoreLoader {
    public static KeyStore load(KeyStore keyStore, CustomScryptConfig scryptConfig) throws CertificateException, IOException, NoSuchAlgorithmException {
        ScryptConfig pbkdfConfig = new ScryptConfig.Builder(scryptConfig.getCostParameter().intValue(), scryptConfig.getBlockSize().intValue(), scryptConfig.getParallelizationParameter().intValue()).withSaltLength(scryptConfig.getSaltLength().intValue()).build();
        BCFKSLoadStoreParameter bcfksLoadStoreParameter = new BCFKSLoadStoreParameter.Builder().withStorePBKDFConfig((PBKDFConfig)pbkdfConfig).build();
        keyStore.load((KeyStore.LoadStoreParameter)bcfksLoadStoreParameter);
        return keyStore;
    }

    private BouncyCastleKeyStoreLoader() {
    }
}

