/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.certificate;

import io.buildlogic.truststore.maven.plugin.certificate.IncludeCertificates;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CertificateFilter {
    private final IncludeCertificates includeCerts;

    public List<X509Certificate> filter(final List<X509Certificate> certs) {
        if (certs == null || certs.size() == 0) {
            return new ArrayList<X509Certificate>();
        }
        switch (this.includeCerts) {
            case ALL: {
                return certs;
            }
            case LEAF: {
                return new ArrayList<X509Certificate>(){
                    {
                        this.add((X509Certificate)certs.get(0));
                    }
                };
            }
            case CA: {
                ArrayList<X509Certificate> caCerts = new ArrayList<X509Certificate>();
                for (int i = 0; i < certs.size(); ++i) {
                    if (i <= 0) continue;
                    caCerts.add(certs.get(i));
                }
                return caCerts;
            }
        }
        throw new RuntimeException("Invalid certificate filtering option");
    }

    public CertificateFilter(IncludeCertificates includeCerts) {
        this.includeCerts = includeCerts;
    }
}

