/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.certificate;

import io.buildlogic.truststore.maven.plugin.certificate.SubjectAltNameParser;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.maven.plugin.logging.Log;

public class CertificateInspector {
    private final SubjectAltNameParser subjectAltNameParser;
    private final X509Certificate cert;

    public CertificateInspector(Log log, X509Certificate cert) {
        this.subjectAltNameParser = new SubjectAltNameParser(log);
        this.cert = cert;
    }

    public String getSerialNumber() {
        BigInteger serialNumber = this.cert.getSerialNumber();
        return this.bigIntToHexString(serialNumber);
    }

    public String getSubject() {
        return this.cert.getSubjectX500Principal().getName();
    }

    public String getIssuer() {
        return this.cert.getIssuerX500Principal().getName();
    }

    public String getNotValidBefore() {
        Date date = this.cert.getNotBefore();
        return this.formatDate(date);
    }

    public String getNotValidAfter() {
        Date date = this.cert.getNotAfter();
        return this.formatDate(date);
    }

    public Optional<String> getSubjectAlternativeNames() {
        return this.subjectAltNameParser.parse(this.cert);
    }

    private String bigIntToHexString(BigInteger number) {
        String numberAsString = number.toString(16);
        if (numberAsString.length() % 2 == 1) {
            numberAsString = String.format("0%s", numberAsString);
        }
        return numberAsString.replaceAll("(?<=..)(..)", ":$1");
    }

    private String formatDate(Date date) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }
}

