/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.certificate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CertificateReader {
    public static List<X509Certificate> read(String file) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        File sourceFile = new File(file);
        try (InputStream inputStream = Files.newInputStream(sourceFile.toPath(), new OpenOption[0]);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            certs.addAll((List)certificateFactory.generateCertificates(inputStream));
        }
        catch (IOException | CertificateException e) {
            String cause = e.getMessage();
            String errorMessage = String.format("Error reading file %s: %s", file, cause);
            throw new RuntimeException(errorMessage, e);
        }
        return certs;
    }

    private CertificateReader() {
    }
}

