/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.certificate;

import io.buildlogic.truststore.maven.plugin.certificate.CertificateDownloader;
import io.buildlogic.truststore.maven.plugin.certificate.SimpleCertificateDownloader;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Supplier;
import org.apache.maven.plugin.logging.Log;

public class RetryingCertificateDownloader
implements CertificateDownloader {
    private final SimpleCertificateDownloader simpleCertificateDownloader;
    private final Log log;

    public RetryingCertificateDownloader(Log log, boolean trustAllCerts, int timeout) {
        this.simpleCertificateDownloader = new SimpleCertificateDownloader(log, trustAllCerts, timeout);
        this.log = log;
    }

    @Override
    public List<X509Certificate> getTlsServerCertificates(InetAddress address, int port) {
        Supplier<List<X509Certificate>> getServerCertsAction = () -> this.simpleCertificateDownloader.getTlsServerCertificates(address, port);
        return this.executeWithRetry(getServerCertsAction);
    }

    private List<X509Certificate> executeWithRetry(Supplier<List<X509Certificate>> action) {
        try {
            return action.get();
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("Error: " + e + ", retrying..."));
            return action.get();
        }
    }
}

