/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.certificate;

import io.buildlogic.truststore.maven.plugin.certificate.CertificateDownloader;
import io.buildlogic.truststore.maven.plugin.net.ConfigurableSSLSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.maven.plugin.logging.Log;

public class SimpleCertificateDownloader
implements CertificateDownloader {
    private final int timeout;
    private final Log log;
    private final SSLSocketFactory sslSocketFactory;

    public SimpleCertificateDownloader(Log log, boolean trustAllCerts, int timeout) {
        this.sslSocketFactory = ConfigurableSSLSocketFactory.createInstance(trustAllCerts);
        this.log = log;
        this.timeout = timeout;
    }

    @Override
    public List<X509Certificate> getTlsServerCertificates(InetAddress address, int port) {
        X509Certificate[] certs;
        this.log.info((CharSequence)("Downloading certificates through TLS handshake from server: " + address + ":" + port));
        try (SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket();){
            InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            socket.setSoTimeout(this.timeout);
            socket.connect(socketAddress, this.timeout);
            SSLSession session = socket.getSession();
            certs = (X509Certificate[])session.getPeerCertificates();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Arrays.asList(certs);
    }
}

