/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.dns;

import io.buildlogic.truststore.maven.plugin.dns.CustomDnsResolver;
import io.buildlogic.truststore.maven.plugin.dns.DnsResolver;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AllDnsResolver
implements DnsResolver {
    private final CustomDnsResolver customResolver;

    public AllDnsResolver(Map<String, String> mappings) {
        this.customResolver = new CustomDnsResolver(mappings);
    }

    @Override
    public List<InetAddress> resolve(String host) {
        try {
            Optional<InetAddress> customAddress = this.customResolver.resolve(host);
            if (customAddress.isPresent()) {
                return Collections.singletonList(customAddress.get());
            }
            InetAddress[] allAddresses = InetAddress.getAllByName(host);
            ArrayList<InetAddress> ipv4Addresses = new ArrayList<InetAddress>();
            for (InetAddress address : allAddresses) {
                if (!(address instanceof Inet4Address)) continue;
                ipv4Addresses.add(address);
            }
            if (ipv4Addresses.size() == 0) {
                throw new RuntimeException("No IPv4 address found for host: " + host);
            }
            return ipv4Addresses;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

