/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;

public class CustomDnsResolver {
    private final Map<String, String> mapping;

    public Optional<InetAddress> resolve(String host) throws UnknownHostException {
        if (this.mapping != null && this.mapping.containsKey(host)) {
            String address = this.mapping.get(host);
            byte[] addressAsBytes = this.toByteArray(address);
            InetAddress inetAddress = InetAddress.getByAddress(host, addressAsBytes);
            return Optional.of(inetAddress);
        }
        return Optional.empty();
    }

    byte[] toByteArray(String address) throws UnknownHostException {
        InetAddress ip = InetAddress.getByName(address);
        return ip.getAddress();
    }

    public CustomDnsResolver(Map<String, String> mapping) {
        this.mapping = mapping;
    }
}

