/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.keystore;

import io.buildlogic.truststore.maven.plugin.bc.BouncyCastleKeyStore;
import io.buildlogic.truststore.maven.plugin.truststore.TruststoreFormat;
import java.security.KeyStore;
import java.security.KeyStoreException;

public class KeyStoreFactory {
    public static KeyStore createInstance(TruststoreFormat format) throws KeyStoreException {
        switch (format) {
            case BKS: 
            case UBER: 
            case BCFKS: {
                return BouncyCastleKeyStore.getInstance(format.toString());
            }
            case JKS: 
            case JCEKS: 
            case PKCS12: {
                return KeyStore.getInstance(format.toString());
            }
        }
        throw new IllegalArgumentException("Unknown file format: " + format);
    }

    private KeyStoreFactory() {
    }
}

