/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.keystore;

import io.buildlogic.truststore.maven.plugin.keystore.KeyStoreFactory;
import io.buildlogic.truststore.maven.plugin.truststore.TruststoreFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public abstract class KeyStoreHandler {
    protected KeyStoreHandler next;

    public KeyStore handleRequest(String file, String password) {
        KeyStore keyStore;
        try (FileInputStream inputStream = new FileInputStream(file);){
            TruststoreFormat format = this.getFormat();
            keyStore = KeyStoreFactory.createInstance(format);
            keyStore.load(inputStream, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            if (e instanceof IOException && this.next != null) {
                return this.next.handleRequest(file, password);
            }
            String cause = e.getMessage();
            String errorMessage = String.format("Error reading file %s: %s", file, cause);
            throw new RuntimeException(errorMessage, e);
        }
        return keyStore;
    }

    public abstract TruststoreFormat getFormat();

    public abstract void setNextHandler(KeyStoreHandler var1);
}

