/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.keystore;

import io.buildlogic.truststore.maven.plugin.keystore.BcfksKeyStoreHandler;
import io.buildlogic.truststore.maven.plugin.keystore.BksKeyStoreHandler;
import io.buildlogic.truststore.maven.plugin.keystore.JceksKeyStoreHandler;
import io.buildlogic.truststore.maven.plugin.keystore.JksKeyStoreHandler;
import io.buildlogic.truststore.maven.plugin.keystore.KeyStoreHandler;
import io.buildlogic.truststore.maven.plugin.keystore.UberKeyStoreHandler;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class KeyStoreReader {
    public static List<X509Certificate> readCertificates(String file, String password) {
        KeyStore keyStore = KeyStoreReader.readKeyStore(file, password);
        return KeyStoreReader.extractCertificates(keyStore);
    }

    public static KeyStore readKeyStore(String file, String password) {
        JksKeyStoreHandler jksKeyStoreHandler = new JksKeyStoreHandler();
        JceksKeyStoreHandler jceksKeyStoreHandler = new JceksKeyStoreHandler();
        BcfksKeyStoreHandler bcfskHandler = new BcfksKeyStoreHandler();
        UberKeyStoreHandler uberKeyStoreHandler = new UberKeyStoreHandler();
        BksKeyStoreHandler bksKeyStoreHandler = new BksKeyStoreHandler();
        ((KeyStoreHandler)jksKeyStoreHandler).setNextHandler(jceksKeyStoreHandler);
        ((KeyStoreHandler)jceksKeyStoreHandler).setNextHandler(bcfskHandler);
        ((KeyStoreHandler)bcfskHandler).setNextHandler(uberKeyStoreHandler);
        ((KeyStoreHandler)uberKeyStoreHandler).setNextHandler(bksKeyStoreHandler);
        return jksKeyStoreHandler.handleRequest(file, password);
    }

    private static List<X509Certificate> extractCertificates(KeyStore keyStore) {
        ArrayList<X509Certificate> certs;
        try {
            certs = new ArrayList<X509Certificate>();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                certs.add(cert);
            }
        }
        catch (KeyStoreException e) {
            String cause = e.getMessage();
            String errorMessage = String.format("Error reading certificates: %s", cause);
            throw new RuntimeException(errorMessage, e);
        }
        return certs;
    }

    private KeyStoreReader() {
    }
}

