/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.mojo;

import io.buildlogic.truststore.maven.plugin.certificate.IncludeCertificates;
import io.buildlogic.truststore.maven.plugin.config.ScryptConfigSelector;
import io.buildlogic.truststore.maven.plugin.config.TruststoreSelector;
import io.buildlogic.truststore.maven.plugin.dns.DnsResolution;
import io.buildlogic.truststore.maven.plugin.mojo.CustomScryptConfig;
import io.buildlogic.truststore.maven.plugin.mojo.Truststore;
import io.buildlogic.truststore.maven.plugin.truststore.TruststoreFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

abstract class ConfigurationMojo
extends AbstractMojo {
    @Parameter(property="truststore.format", defaultValue="PKCS12")
    protected TruststoreFormat truststoreFormat;
    @Parameter(property="truststore.file", required=true)
    protected String truststoreFile;
    @Parameter(property="truststore.password", defaultValue="changeit")
    protected String truststorePassword;
    @Parameter(property="truststore.certificates")
    protected List<String> certificates;
    @Parameter
    private List<Truststore> truststores;
    @Parameter(property="truststore.truststores")
    private String truststoresProperty;
    @Parameter(property="truststore.includeDefaultTruststore", defaultValue="false")
    protected boolean includeDefaultTruststore;
    @Parameter(property="truststore.servers")
    protected List<String> servers;
    @Parameter(property="truststore.trustAllCertificates", defaultValue="false")
    protected boolean trustAllCertificates;
    @Parameter(property="truststore.retryDownloadOnFailure", defaultValue="true")
    protected boolean retryDownloadOnFailure;
    @Parameter(property="truststore.downloadTimeout", defaultValue="10000")
    protected int downloadTimeout;
    @Parameter(property="truststore.dnsResolution", defaultValue="ALL")
    protected DnsResolution dnsResolution;
    @Parameter(property="truststore.dnsMappings")
    private List<String> dnsMappings;
    @Parameter(property="truststore.includeCertificates", defaultValue="ALL")
    protected IncludeCertificates includeCertificates;
    @Parameter
    protected CustomScryptConfig scryptConfig;
    @Parameter(property="truststore.scryptConfig")
    private String scryptConfigProperty;
    @Parameter(property="truststore.skip", defaultValue="false")
    protected boolean skip;

    ConfigurationMojo() {
    }

    protected List<Truststore> getTruststores() {
        TruststoreSelector truststoreSelector = new TruststoreSelector();
        return truststoreSelector.select(this.truststores, this.truststoresProperty);
    }

    protected Map<String, String> getDnsMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String mapping : this.dnsMappings) {
            int separator = mapping.indexOf(":");
            String host = mapping.substring(0, separator);
            String address = mapping.substring(separator + 1);
            mappings.put(host, address);
        }
        return mappings;
    }

    protected CustomScryptConfig getScryptConfig() {
        ScryptConfigSelector scryptConfigSelector = new ScryptConfigSelector();
        CustomScryptConfig selectedConfig = scryptConfigSelector.select(this.scryptConfig, this.scryptConfigProperty);
        if (selectedConfig != null) {
            selectedConfig.validate();
        }
        return selectedConfig;
    }
}

