/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.mojo;

import io.buildlogic.truststore.maven.plugin.bc.BouncyCastleKeyStore;
import io.buildlogic.truststore.maven.plugin.certificate.CertificateDownloader;
import io.buildlogic.truststore.maven.plugin.certificate.CertificateFilter;
import io.buildlogic.truststore.maven.plugin.certificate.CertificateReader;
import io.buildlogic.truststore.maven.plugin.certificate.RetryingCertificateDownloader;
import io.buildlogic.truststore.maven.plugin.certificate.SimpleCertificateDownloader;
import io.buildlogic.truststore.maven.plugin.dns.DnsResolver;
import io.buildlogic.truststore.maven.plugin.dns.DnsResolverFactory;
import io.buildlogic.truststore.maven.plugin.file.FileChecker;
import io.buildlogic.truststore.maven.plugin.keystore.KeyStoreReader;
import io.buildlogic.truststore.maven.plugin.mojo.ConfigurationMojo;
import io.buildlogic.truststore.maven.plugin.mojo.CustomScryptConfig;
import io.buildlogic.truststore.maven.plugin.mojo.Truststore;
import io.buildlogic.truststore.maven.plugin.truststore.TruststoreFormat;
import io.buildlogic.truststore.maven.plugin.truststore.TruststoreWriter;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-truststore", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class TruststoreMojo
extends ConfigurationMojo {
    private final List<X509Certificate> certs = new ArrayList<X509Certificate>();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Requested to skip Truststore Maven Plugin execution");
            return;
        }
        this.validateConfig();
        this.loadFileSystemCerts();
        this.loadFileSystemTruststores();
        this.loadTlsCerts();
        this.loadDefaultTruststore();
        this.createTruststore();
    }

    private void validateConfig() {
        this.validateDownloadTimeout();
        this.validateScryptConfig();
        this.validateProviderDependency();
    }

    private void validateDownloadTimeout() {
        if (this.downloadTimeout < 0) {
            throw new RuntimeException("downloadTimeout can not be negative");
        }
    }

    private void validateScryptConfig() {
        if (this.scryptConfig != null) {
            this.scryptConfig.validate();
        }
    }

    private void validateProviderDependency() {
        HashSet<TruststoreFormat> bouncycastleFormats = new HashSet<TruststoreFormat>(){
            {
                this.add(TruststoreFormat.BKS);
                this.add(TruststoreFormat.BCFKS);
                this.add(TruststoreFormat.UBER);
            }
        };
        if (bouncycastleFormats.contains((Object)this.truststoreFormat)) {
            BouncyCastleKeyStore.getProvider();
        }
    }

    private void loadFileSystemCerts() {
        for (String certificateFile : this.certificates) {
            this.getLog().info((CharSequence)("Loading certificates from file: " + certificateFile));
            List<X509Certificate> newCerts = CertificateReader.read(certificateFile);
            this.certs.addAll(newCerts);
        }
    }

    private void loadFileSystemTruststores() {
        List<Truststore> truststores = this.getTruststores();
        for (Truststore sourceTruststore : truststores) {
            String file = sourceTruststore.getFile();
            String password = sourceTruststore.getPassword();
            this.getLog().info((CharSequence)("Loading certificates from truststore: " + file));
            this.readCertificates(file, password);
        }
    }

    private void loadTlsCerts() {
        Map<String, String> dnsMappings = this.getDnsMappings();
        DnsResolver dnsResolver = DnsResolverFactory.getInstance(this.dnsResolution, dnsMappings);
        CertificateDownloader certDownloader = this.getCertDownloader();
        CertificateFilter certFilter = new CertificateFilter(this.includeCertificates);
        for (String server : this.servers) {
            int separator = server.indexOf(":");
            String host = server.substring(0, separator);
            int port = Integer.parseInt(server.substring(separator + 1));
            List<InetAddress> addresses = dnsResolver.resolve(host);
            List<X509Certificate> downloadedCerts = null;
            for (InetAddress address : addresses) {
                downloadedCerts = certDownloader.getTlsServerCertificates(address, port);
            }
            List<X509Certificate> filteredCerts = certFilter.filter(downloadedCerts);
            this.certs.addAll(filteredCerts);
        }
    }

    private void loadDefaultTruststore() throws MojoExecutionException {
        if (this.includeDefaultTruststore) {
            String javaHome = System.getProperty("java.home");
            String jssecacerts = String.format("%s/lib/security/jssecacerts", javaHome);
            String cacerts = String.format("%s/lib/security/cacerts", javaHome);
            String defaultPassword = "changeit";
            if (FileChecker.isReadableFile(jssecacerts)) {
                this.getLog().info((CharSequence)("Loading certificates from default truststore: " + jssecacerts));
                this.readCertificates(jssecacerts, defaultPassword);
            } else if (FileChecker.isReadableFile(cacerts)) {
                this.getLog().info((CharSequence)("Loading certificates from default truststore: " + cacerts));
                this.readCertificates(cacerts, defaultPassword);
            } else {
                throw new MojoExecutionException("Default truststore not found");
            }
        }
    }

    private void readCertificates(String file, String password) {
        List<X509Certificate> newCerts = KeyStoreReader.readCertificates(file, password);
        this.certs.addAll(newCerts);
    }

    private void createTruststore() {
        Log log = this.getLog();
        TruststoreWriter truststoreWriter = new TruststoreWriter(log, this.truststoreFormat, this.truststoreFile, this.truststorePassword);
        CustomScryptConfig scryptConfig = this.getScryptConfig();
        if (this.truststoreFormat.equals((Object)TruststoreFormat.BCFKS) && scryptConfig != null) {
            truststoreWriter.setScryptConfig(scryptConfig);
        }
        truststoreWriter.write(this.certs);
    }

    private CertificateDownloader getCertDownloader() {
        Log log = this.getLog();
        if (this.retryDownloadOnFailure) {
            return new RetryingCertificateDownloader(log, this.trustAllCertificates, this.downloadTimeout);
        }
        return new SimpleCertificateDownloader(log, this.trustAllCertificates, this.downloadTimeout);
    }
}

