/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.net;

import io.buildlogic.truststore.maven.plugin.net.KeyManagersFactory;
import io.buildlogic.truststore.maven.plugin.net.TrustManagersFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ConfigurableSSLSocketFactory {
    private ConfigurableSSLSocketFactory() {
    }

    public static SSLSocketFactory createInstance(boolean trustAllCerts) {
        SSLContext sslContext;
        KeyManager[] keyManagers = KeyManagersFactory.createInstance();
        TrustManager[] trustManagers = TrustManagersFactory.createInstance(trustAllCerts);
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return sslContext.getSocketFactory();
    }
}

