/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.net;

import io.buildlogic.truststore.maven.plugin.keystore.KeyStoreReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public class KeyManagersFactory {
    private KeyManagersFactory() {
    }

    public static KeyManager[] createInstance() {
        KeyManagerFactory keyManagerFactory;
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        String keyStoreFile = System.getProperty("javax.net.ssl.keyStore", null);
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", null);
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            if (keyStoreFile != null && keyStorePassword != null) {
                KeyStore keyStore = KeyStoreReader.readKeyStore(keyStoreFile, keyStorePassword);
                keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
            } else {
                keyManagerFactory.init(null, null);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        return keyManagerFactory.getKeyManagers();
    }
}

